<?php
session_start();
	if(!isset($_SESSION['username'])){
		header('location:login.php');
		exit;
	}

	include('../postfolder/connexion.php');

?>
<!DOCTYPE html>
<html>
<head>
	<link rel="stylesheet" href="../css/staffStyle.css?v=<?php time() ?>">
	<link rel="stylesheet" href="../css/font-awesome/css/font-awesome.min.css">	
	<link id="bs-css" href="../css/jqD.css" rel="stylesheet">
	<title></title>
<style>
	#table{
		width: 90%;
		margin:auto;
		margin-top:20px;
		border-collapse: collapse;
	}
	th{
		border:1px solid #aaa;
	}
	td{
		border:1px solid #aaa;
	}
	.dataTables_wrapper .dataTables_length, .dataTables_wrapper .dataTables_filter, .dataTables_wrapper .dataTables_info, .dataTables_wrapper .dataTables_processing, .dataTables_wrapper .dataTables_paginate{
		margin:20px;
	}
	img{
		width:200px;
		height:200px;
	}
	#addButton {
	    padding: 8px 17px;
	    cursor: pointer;
	}
	#form{
		display: none;
		background-color: white;
		padding: 20px;
		width: 60%;
		border: 1px solid grey;
	}
	form input, div textarea{
		width:70%;
		padding:7px;
		margin-bottom: 10px;
	}
	#form form label{
		font-weight: bold;
		display:block;
	}
	
	.critical{
		color:red;
	}
	.aaa{
		text-decoration: none;
		border: 1px solid black;
		padding: 8px 10px;
		color: black;
		margin-top: 20px;
		display: inline-block;
	}
	#aaaActive{
		border: 1px solid #7baa2f;
		color: #7baa2f;
		padding: 8px 10px;
	}
	#item_name{
        left:300px;
        padding:5px;
        border-radius: 30px;
        margin-bottom: 20px;
    }
	table{
		width:80%;
	}
	td,th{
		text-align: center;
		padding:10px;
	}
	
	#updatePopup{
		width: 400px;
		height: 507px;
		background: white;
		z-index:500;
		position: fixed;
		top:calc( 50% - 250px );
		left:calc( 50% - 200px );
		padding:15px;
		border:1px solid black;
		display: none;
		overflow-y: auto;
	}
	#updatePopup input, #updatePopup select{
		width: 100%;
	}
	.closeRound{
		background-color:black;
		color:white;
		position: absolute;
		top:2px;
		right: 2px;
		padding:3px 4px 4px 3px;
		border-radius: 30px;
		cursor:pointer;


	}
	#updatePopup form > div{
		display: flex;
		flex-direction: column;
		margin-bottom: 5px;
	}
</style>
</head>
<body>
	<?php include('header.php'); ?>
<section>

	<div style="margin-bottom:10px">
		<a class="aaa" href='stock.php'>View stock list</a>
		<a class='aaa' href='store.php'>Edit stock list</a>
		<a id='aaaActive' href='#'>Edit bulk items</a>
		<a class='aaa' href='sqa.php'>Stock adj. history</a>
	</div>


	<button class='addSomething' id='addButton'> Add Bulk Variation</button>
	<div id='form'>

		<form method="post" action='store.php'>
			<input type='hidden' name='bulkVariationAdd' >
			
			<div>
				<label>Bulk variation name</label>
				<input type='text' name='bv_name' id='bv_name' required>
			</div>
			<div>
				<label>Variation Qty ( One of this item equal to this qty of the main item )</label>
				<input type='number' name='bv_quantity' id='bv_quantity' step='0.1' required>
			</div>
			<div>
				<label>Variation Price</label>
				<input type='number' name='bv_price' id='bv_price' step='0.1' required>
			</div>
			
		
			<div>
				<label>Main Item ID</label>
				<input type='number' name='bv_item_id' step='0.1' required>
			</div>

			<input type='submit' value='submit'>
		</form>
	</div>

	<div>
		<table id='table'>
			<thead>
				<tr>
					<th>Variation id</th>
					<th>Variation name</th>
					<th>Variation price</th>
					<th>Variation Qty</th>
					<th>Main Item Id</th>
					<th>Status</th>
					<th>Actions</th>
				</tr>
			</thead>
			<tbody>
		<?php 
			$req = $bdd->query('SELECT * FROM item where isbv = 1 ORDER BY item_id DESC');
			while($reqq = $req->fetch()){

					$reqC = $bdd->prepare('SELECT * FROM itemcategory where icID = ?');
					$reqC->execute(array($reqq["item_icId"]));
					$reqqC = $reqC->fetch();
				?>				
						<tr>
							<td class='id'><strong><?php echo $reqq["item_id"];?></strong></td>
							<td class='name'><?php echo $reqq["item_name"];?> </td>
							<td class='bv_price'><?php echo $reqq["item_price"];?></td>
							<td class='bv_qty'><?php echo $reqq["bv_qty"];?></td>
							<td class='bv_item_id'><?php echo $reqq["bv_item_id"];?></td>
							<td class='status'><?php echo $reqq["item_disabled"];?></td>
							<td ><button class='actionButton edit'>Edit</button></td>
						</tr>						
				<?php
			}
		?>
			</tbody>
		</table>
	</div>

	<div id='updatePopup'>
		<i class='closeRound fa fa-remove'></i>
		<h3>Edit Location</h3>
		<form id='updateForm'>
			<input type='hidden' name='variationUpdate' id='updateHidden' >
				<div>
					<label>Bulk variation name</label>
					<input type='text' name='bv_name' id='ebv_name' required>
				</div>
				<div>
					<label>Variation Qty</label>
					<input type='number' name='bv_quantity' id='ebv_quantity' step='0.1' required>
				</div>
				<div>
					<label>Variation Price</label>
					<input type='number' name='bv_price' id='ebv_price' step='0.1' required>
				</div>
				
				
				<div>
					<label>Main Item ID</label>
					<input type='number' name='ebv_item_id' id='ebv_item_id' step='0.1' required>
				</div>
				<div>
					<label>Status</label>
					<select name='bv_status' id='ebv_status'>
						<option>Enabled</option>
						<option>Disabled</option>
					</select>
				</div>
			
			<input type='submit' value='Update'>
		</form>
	</div>

</section>
<?php include('footer.php'); ?>
<script src="../js/jqD.js"></script>
<script type="text/javascript">
	$(document).ready(function(){

		var table = $('#table').dataTable({
			"lengthMenu": [[50,100,200, -1], [50,100,200, "All"]]
		})
		

	})
	$('#addButton').click(function(){
		$('#form').slideToggle();
	})

	$('.closeRound').click(function(){
		$(this).parent().hide()
		affectedTr = null;
	})

	$('#form form').submit(function(e){
		e.preventDefault()

			var data = $(this).serialize();

         $.ajax({
	           url:'postfolder/itemOperations.php',
	           type:'post',
	           data:data,
	           dataType:'text',
	           success: function(donnee,statut){
	           		console.log(donnee)
	           		$('#form form')[0].reset()
	           		notify('success','Bulk variation added. Refresh to see changes');
	           		
	           },
	           error:function(){
	           
	           }
         })
	})

	var affectedTr;

	$('.edit').click(function(){
		affectedTr = $(this).parent('td').parent('tr')
		id = affectedTr.children('.id').text()
		name = affectedTr.children('.name').text()
		bv_price = affectedTr.children('.bv_price').text()
		bv_qty = affectedTr.children('.bv_qty').text()
		bv_item_id = affectedTr.children('.bv_item_id').text()
		status = affectedTr.children('.status').text()
		if(status == '') status = 'Enabled'
		else status = 'Disabled'
		
		$('#updateHidden').val(id)
		$('#ebv_name').val(name)
		$('#ebv_price').val(bv_price)
		$('#ebv_quantity').val(bv_qty)
		$('#ebv_item_id').val(bv_item_id)
		$('#ebv_status').val(status).change()
		
		$('#updatePopup').show(200)
	})

	$('#updateForm').submit(function(e){
		e.preventDefault()

			var data = $(this).serialize();
			d = new FormData($(this)[0])

         $.ajax({
	           url:'postfolder/itemOperations.php',
	           type:'post',
	           data:data,
	           dataType:'text',
	           success: function(donnee,statut){
	           		if(donnee.trim() == 'ok'){

	           			notify('success','Bulk variation updated');

							affectedTr.children('.name').text(d.get('bv_name'))
							affectedTr.children('.bv_qty').text(d.get('bv_quantity'))
							affectedTr.children('.bv_price').text(d.get('bv_price'))
							affectedTr.children('.bv_item_id').text(d.get('ebv_item_id'))

							var newStatus = '';
							if(d.get('bv_status') == 'Disabled') newStatus = 'disabled'
							affectedTr.children('.status').text(newStatus)
							
							
							
							$('#updatePopup').slideUp(200)
						}
	           },
	           error:function(){
	           
	           }
         })
	})

   //   $('#item_name').on('keyup',function(e){
   //   	load()
   //   })
   //   $('#item_category').on('change',function(e){
   //   	load()
   //   })
   //   $('#sort').on('change',function(e){
   //   	load()
   //   })

   // load = function(){
     	

   //   	data = {
   //   		sort:'ok',
   //   		name:$('#item_name').val(),
   //   		sortVal:$('#sort').val(),
   //   		category:$('#item_category').val()
   //   	}
     	
   //   	$('#storeReportLink').attr('href','storeReport.php?sortVal='+$('#sort').val()+'&category='+$('#item_category').val()+'&name='+$('#item_name').val())
   //               $.ajax({
   //               url:'postfolder/salesOperations.php',
   //               type:'post',
   //               data:data,
   //               dataType:'json',
   //               success: function(donne,statut){
   //               	console.log(donne)
   //                  $('tbody').empty()
                   
			// 	donne.forEach(function(dt){
			// 		$('<tr>')
			// 		.append($('<td>').text(dt['item_id']))
			// 		.append($('<td>').text(dt['item_name']))
			// 		.append($('<td>').text(dt['item_quantity']))
			// 		.append($('<td>').text(dt['item_price']))
			// 		.append($('<td>').text(dt['item_icId']))
			// 		.append($('<td>').text(dt['item_barcode']))
					
					
			// 		.appendTo($('tbody'))
			// 	})
                     
                                         
   //               }
   //           })
   // }
</script>
</body>
</html>