<?php
session_start();
if(!isset($_SESSION['username'])){
	header('location:login.php');
	exit;
}
include('../postfolder/connexion.php');
?>
<!DOCTYPE html>
<html>
<head>
	<link rel="stylesheet" href="../css/staffStyle.css?v=<?php time() ?>">
    <link rel="stylesheet" href="../css/font-awesome/css/font-awesome.min.css">
    <link id="bs-css" href="../css/jqD.css" rel="stylesheet">
	<title>Petty cash</title>
<style>
	#table{
		
		margin:auto;
		margin-top:20px;
		border-collapse: collapse;
	}
	th{
		border:1px solid #aaa;
	}
	td{
		border:1px solid #aaa;
	}
	.dataTables_wrapper .dataTables_length, .dataTables_wrapper .dataTables_filter, .dataTables_wrapper .dataTables_info, .dataTables_wrapper .dataTables_processing, .dataTables_wrapper .dataTables_paginate{
		margin:20px;
	}


	#complain{
		display: none;
	}
	

	input[type=date]{
/*		line-height: 33px;*/
		position: relative;
		bottom: 1px;
		font-weight: bold;
		width: 139px;
	}
	form input, form div textarea{
		width:70%;
		padding:7px;
		margin-bottom: 10px;
	}
	form label{
		font-weight: bold;
		display:block;
	}
	
</style>
</head>
<body>
<?php include('header.php'); ?>
<section>
<div style='width:90%;margin:auto;margin-top:30px'>
	

	<?php
		$date=date_create(date('Y-m-d'));
          	

		$recorder = '';
        $startDate = date_format($date,"Y-m-d");
        $endDate = date("Y-m-d");
        $staffs = '';
        


        if(isset($_POST['cashier'])){
			$recorder = $_POST['cashier'];
			$staffs = $_POST['staffs'];
			$startDate= htmlspecialchars($_POST['startDate']);
    		$endDate = htmlspecialchars($_POST['endDate']);
    		
    	}
	?>

	<form  style='display: none' id='exportForm' method='post' action='postfolder/pettycashExport.php'>
		<input type="text" id="cashierA" name="cashier" >
		<input type="text" id="staffsA" name="staffs" >
		<input type="date" id='startDateA' name="startDate">
		<input type="date" id='endDateA' name="endDate">
		<input type='submit' value='submit'>
	</form>

	<form id='filter' method='post' action='pettycashreport.php'>
		<select name='cashier' id='cashier'>
			<option value=''>All cashiers</option>
			<?php

				

				$reqWorker = $bdd->query('SELECT * FROM workers where s_category = "cashier" OR s_category = "Admin"  ORDER BY ID ');

				while($reqWorkers = $reqWorker->fetch()){ 
					$selected = '';

					if($reqWorkers['ID'] == $recorder) $selected = 'selected';
					?>
					<option value="<?php echo $reqWorkers['ID'];?>" <?= $selected ?>><?php echo $reqWorkers['s_name'];?></option>
				<?php }
			?>
		</select>

		<select name='staffs' id='staffs'>
			<option value=''>All staffs</option>
			<?php

				$reqstaff = $bdd->query('SELECT * FROM workers ORDER BY ID ');

				while($reqsatffs = $reqstaff->fetch()){ 
					$selected = '';

					if($reqsatffs['ID'] == $staffs) $selected = 'selected';
					?>
					<option value="<?php echo $reqsatffs['ID'];?>" <?= $selected ?>><?php echo $reqsatffs['s_name'];?></option>
				<?php }
			?>
		</select>
		
		<input type='date' name='startDate' id='startDate' value="<?= $startDate ?>">
		<input type='date' name='endDate' id='endDate' value="<?= $endDate ?>">
		
		<input style='padding:5px 25px' type="submit" value='Filter'>
	</form>


	<button id='addMessage' style="padding: 7px 15px;">Record a petty cash</button>
	<?php

		if(isset($_GET['error'])){
			?>
			<p style='width:500px; border-width: 1px; padding:5px' class="error">
				<?php echo $_GET['error'];?>
			</p>
			<?php
		}
		else if(isset($_GET['success'])){
			?>
			<p style='width:500px; border-width: 1px; padding:5px' class="success">
				<?php echo $_GET['success'];?>
			</p>
			<?php
		}
	?>
	<div id='complain'>
		<form method='post' action='postfolder/complainpost.php'>
			<input type="hidden" name="recordPettyCash">
			<div>
				<label for='c_customerName'> Staff name</label>
				<select name='cashier' id='cashier'>
					<option value=''>All staffs</option>
					<?php
						$reqWorker = $bdd->query('SELECT * FROM workers where s_category != "Admin" ORDER BY ID ');

						while($reqWorkers = $reqWorker->fetch()){ 
							

							?>
							<option value="<?php echo $reqWorkers['ID'];?>" ><?php echo $reqWorkers['s_name'];?></option>
						<?php }
					?>
				</select>
			</div>
			<div>
				<label for='amount'>Amount </label>
				<input type='number' name='amount' required id='amount'  >
			</div>
			
			<div>
				<label for='reason'> Reason</label>
				<textarea type='text' name='reason' rows='6' required id='reason'></textarea>
			</div>
			<input type='submit' value="Record">
		</form>
	</div>	

	<button id='export' style='display:block; margin-bottom: 20px; cursor:pointer'>
		Export in Excel
	</button>

	<h1>Petty cash</h1>

	<table id='table'>
		<thead>
			<tr>
				<th>N•</th>
				<th>Staff ID</th>
				<th>Staff Name</th>
				<th>Amount</th>
				<th>Reason</th>
				<th>Date & time</th>
				<th>Recording staff</th>
			</tr>
		</thead>
		<tbody>
		<?php 
			$i = 1;

			$recorder = '%'.$recorder.'%';
			$staffs = '%'.$staffs.'%';

			$startTime = $startDate.' 00:00:00';
    		$endTime = $endDate.' 23:59:59';

			$req = $bdd->prepare('SELECT pc_staff_id, pc_amount, pc_reason, pc_date, ww.s_name As ss, w.s_name as se FROM pettycash LEFT JOIN  workers ww ON ww.ID = pc_staff_id LEFT JOIN workers w ON w.ID = pc_recording_staffs  WHERE pc_recording_staffs LIKE :ID AND pc_staff_id LIKE :staffs AND pc_date >= :startdate AND pc_date <= :endDate ORDER BY pc_date DESC ');
			$req->bindParam(':ID', $recorder, PDO::PARAM_STR, 12);
			$req->bindParam(':staffs', $staffs, PDO::PARAM_STR, 12);
			$req->bindParam(':startdate', $startTime, PDO::PARAM_STR, 12);
			$req->bindParam(':endDate', $endTime, PDO::PARAM_STR, 12);
			$req->execute();
			
			while ($reqq = $req->fetch()) {
			?>
				<tr>

					<td><?php echo $i;?></td>
					<td><?php echo $reqq['pc_staff_id'];?></td>
					<td><?php echo $reqq['ss'];?></td>
					<td><?php echo $reqq['pc_amount'];?></td>
					<td><?php echo $reqq['pc_reason'];?></td>
					<td><?php echo aDate($reqq['pc_date']);?></td>
					<td><?php echo $reqq['se'];?></td>
					
				</tr>
				<?php
				$i++;
			
			}
		?>
			</div>
		
		
		
		</div>
		</div>
		
	</div>
</div>
</section>
<?php include('footer.php'); ?>
<script src="../js/jqD.js"></script>
<script type="text/javascript">

	$(document).ready(function(){
		var table = $('#table').dataTable({
			"lengthMenu": [[50,100,200, -1], [50,100,200, "All"]]
		})
	})

	$('#addMessage').click(function(){
		$('#complain').toggle(200)
	})

	$('#export').click(function(){
		$('#cashierA').val($('#cashier').val())
		$('#staffsA').val($('#staffs').val())
		$('#startDateA').val($('#startDate').val())
		$('#endDateA').val($('#endDate').val())
		

		$('#exportForm').submit()
		
	})
</script>
	

</body>
</html>