<?php
	include('../../postfolder/connexion.php');
	require '../../vendor/vendor/autoload.php';
	
if(isset($_POST['bulkVariationAdd'])){


	$getCat = $bdd->prepare('SELECT item_isstockable, item_icId FROM item where item_id = ?');
	$getCat->execute(array(htmlspecialchars($_POST['bv_item_id'])));
	$gettCat = $getCat->fetch();

	$reqAdd = $bdd->prepare('INSERT INTO item(item_name, item_quantity,  item_price, item_barcode, item_icId, isbv, bv_item_id, bv_qty, item_isstockable) VALUES(?,?,?,?,?,?,?,?,?)');
	$reqAdd->execute(array(htmlspecialchars($_POST['bv_name']),1,htmlspecialchars($_POST['bv_price']), '', $gettCat['item_icId'], 1, htmlspecialchars($_POST['bv_item_id']), htmlspecialchars($_POST['bv_quantity']), $gettCat['item_isstockable']));

	echo 'ok';
}
if(isset($_POST['variationUpdate'])){

	
	$status = '';
	if($_POST['bv_status'] == 'Disabled') $status = 'disabled';

	$reqUpdate = $bdd->prepare("UPDATE item SET item_name = ?, item_disabled=?, item_price=?, bv_item_id=?, bv_qty =? WHERE item_id=? ");
	$reqUpdate->execute(array(htmlspecialchars($_POST['bv_name']), $status, htmlspecialchars($_POST['bv_price']),htmlspecialchars($_POST['ebv_item_id']),htmlspecialchars($_POST['bv_quantity']),htmlspecialchars($_POST['variationUpdate'])));

	echo 'ok';

}
if(isset($_POST['itemUpdate'])){

	$reqSelect = $bdd->prepare('SELECT item_quantity FROM item WHERE item_id = ?');
	$reqSelect->execute(array(htmlspecialchars($_POST['item_id'])));
	$reqqSelect = $reqSelect->fetch();
	

	if(htmlspecialchars($_POST['qty']) != htmlspecialchars($reqqSelect['item_quantity'])){
		$reqSqa = $bdd->prepare('INSERT INTO stockquantityadjust(sqa_item_id,sqa_squantity,sqa_equantity,sqa_quantity,sqa_channel,sqa_time) VALUES(?,?,?,?,"supdate",NOW())');
		$reqSqa->execute(array(htmlspecialchars($_POST['item_id']), htmlspecialchars($reqqSelect['item_quantity']), htmlspecialchars($_POST['qty']), (htmlspecialchars($_POST['qty']) - htmlspecialchars($reqqSelect['item_quantity']))));
	}
	
	$reqUp = $bdd->prepare('UPDATE item SET item_name=?, item_quantity = ?, item_icId=?,  item_barcode =?, item_buy_price=?, item_price=?, item_isstockable = ? WHERE item_id = ?');
	$reqUp->execute(array(htmlspecialchars($_POST['name']),htmlspecialchars($_POST['qty']),htmlspecialchars($_POST['category']),htmlspecialchars($_POST['barcode']), htmlspecialchars($_POST['buyprice']),htmlspecialchars($_POST['price']),htmlspecialchars($_POST['isstockable']), htmlspecialchars($_POST['item_id'])));
	

	echo 'ok';
}

if(isset($_POST['add'])){
	// print_r($_POST);
	$isstockable = 0;
	if(isset($_POST['item_stockable'])) $isstockable = 1;

	$reqAdd = $bdd->prepare('INSERT INTO item(item_name, item_quantity, item_buy_price, item_price, item_barcode, item_icId, item_isstockable) VALUES(?,?,?,?,?,?,?)');
	$reqAdd->execute(array(htmlspecialchars($_POST['item_name']),htmlspecialchars($_POST['item_quantity']), htmlspecialchars($_POST['item_buy_price']), htmlspecialchars($_POST['item_price']), htmlspecialchars($_POST['item_barcode']), htmlspecialchars($_POST['item_category']), $isstockable ));

	echo 'ok';
}

if(isset($_POST['maxImportCheck'])){

	
	$validCategories = [];
	$req = $bdd->query('SELECT * FROM itemcategory ORDER BY icId DESC');
	while($reqq = $req->fetch()){
		array_push($validCategories, $reqq['icId']);
	}
	
	$errors = [];

	$validHeaders = ['item_name','item_quantity','item_buying_price','item_price','item_category','item_barcode','item_status','isstockable'];
	
	$extensions = strtolower(strrchr($_FILES['file']['name'], '.'));

	if($extensions == '.xlsx') $reader = new \PhpOffice\PhpSpreadsheet\Reader\Xlsx();
	else if($extensions == '.xls') $reader = new \PhpOffice\PhpSpreadsheet\Reader\Xls();
	else{
		echo '<li>The supported formats are xlsx and xls </li>';
		exit;
	}
	
	$file = $_FILES['file']['tmp_name'];
	$spreadsheet = $reader->load($file);

	$content = $spreadsheet->getSheet(0)->toArray();
	$headers = $content[0];

	$namePosition =1000;
	$buypricePosition =1000;
	$pricePosition =1000;
	$qtyPosition =1000;
	$categoryPosition =1000;
	$barcodePosition =1000;
	$statusPosition =1000;
	$stockablePosition =1000;

	if(in_array('item_name',$content[0])) $item_name = array_search('item_name',$content[0]);
	if(in_array('item_quantity',$content[0])) $qtyPosition = array_search('item_quantity',$content[0]);
	if(in_array('item_buying_price',$content[0])) $buypricePosition = array_search('item_buying_price',$content[0]);
	if(in_array('item_price',$content[0])) $pricePosition = array_search('item_price',$content[0]);
	if(in_array('item_category',$content[0])) $categoryPosition = array_search('item_category',$content[0]);
	if(in_array('item_barcode',$content[0])) $barcodePosition = array_search('item_barcode',$content[0]);
	if(in_array('item_status',$content[0])) $statusPosition = array_search('item_status',$content[0]);
	if(in_array('isstockable',$content[0])) $stockablePosition = array_search('isstockable',$content[0]);

	if(!in_array('item_name',$headers)){
		echo '<li>Missing important column item_name</li>';
		exit;
	}
	
	foreach($headers as $header){
		if(!in_array($header,$validHeaders)){
			array_push($errors,'header "'.$header. '" is an invalid column');
		} 
	}

	for($i=1;$i< count($content);$i++){

		if($categoryPosition != 1000){
			if(!in_array($content[$i][$categoryPosition],$validCategories)){
				array_push($errors,'Category "'.$content[$i][$categoryPosition]. '" is an invalid category on line '.($i+1));
			}
		}
		if($statusPosition != 1000){
			if($content[$i][$statusPosition] AND $content[$i][$statusPosition] != 'disabled'){
				array_push($errors,'"'.$content[$i][$statusPosition]. '" is not valid status on line '.($i+1));
			}
		}
		if($buypricePosition != 1000){
			if($content[$i][$buypricePosition] AND !is_numeric($content[$i][$buypricePosition])){
				array_push($errors,'"'.$content[$i][$buypricePosition]. '" is not valid price on line '.($i+1));
			}
		}
		if($pricePosition != 1000){
			if($content[$i][$pricePosition] AND !is_numeric($content[$i][$pricePosition])){
				array_push($errors,'"'.$content[$i][$pricePosition]. '" is not valid price on line '.($i+1));
			}
		}
		if($qtyPosition != 1000){
			if($content[$i][$qtyPosition] AND !is_numeric($content[$i][$qtyPosition])){
				array_push($errors,'"'.$content[$i][$qtyPosition]. '" is not valid quantity on line '.($i+1));
			}
		}

		if($stockablePosition != 1000){
			if($content[$i][$stockablePosition] AND !in_array($content[$i][$stockablePosition],[0,1])){
				array_push($errors,'isstockable column value must be 0 or 1 on line '.($i+1));
			}
		}
		
	}


	if(count($errors) > 0){
		foreach($errors as $error){
			echo '<li>'.$error.'</li>';
		}
		exit;
	}

	echo 'pass';
}
if(isset($_POST['maxImportUpload'])){
	
	$defaultPrice = 1; $defaultCategory = 'default'; $defaultQuantity = 0;

	$extensions = strtolower(strrchr($_FILES['file']['name'], '.'));
	if($extensions == '.xlsx') $reader = new \PhpOffice\PhpSpreadsheet\Reader\Xlsx();
	else if($extensions == '.xls') $reader = new \PhpOffice\PhpSpreadsheet\Reader\Xls();
	
	$file = $_FILES['file']['tmp_name'];
	$spreadsheet = $reader->load($file);

	$content = $spreadsheet->getSheet(0)->toArray();
	$headers = $content[0];

	$namePosition =1000;
	$buypricePosition =1000;
	$pricePosition =1000;
	$qtyPosition =1000;
	$categoryPosition =1000;
	$barcodePosition =1000;
	$statusPosition =1000;
	$stockablePosition =1000;

	if(in_array('item_name',$content[0])) $namePosition = array_search('item_name',$content[0]);
	if(in_array('item_quantity',$content[0])) $qtyPosition = array_search('item_quantity',$content[0]);
	if(in_array('item_buying_price',$content[0])) $buypricePosition = array_search('item_buying_price',$content[0]);
	if(in_array('item_price',$content[0])) $pricePosition = array_search('item_price',$content[0]);
	if(in_array('item_category',$content[0])) $categoryPosition = array_search('item_category',$content[0]);
	if(in_array('item_barcode',$content[0])) $barcodePosition = array_search('item_barcode',$content[0]);
	if(in_array('item_status',$content[0])) $statusPosition = array_search('item_status',$content[0]);
	if(in_array('isstockable',$content[0])) $stockablePosition = array_search('isstockable',$content[0]);

	
	for($i=1;$i< count($content);$i++){

		$realBuyPrice = 0;
		if($buypricePosition != 1000 && $content[$i][$buypricePosition]) $realBuyPrice = $content[$i][$buypricePosition];

		$realPrice = 0;
		if($pricePosition != 1000 && $content[$i][$pricePosition]) $realPrice = $content[$i][$pricePosition];

		$realQuantity = 0;
		if($qtyPosition != 1000 && $content[$i][$qtyPosition]) $realQuantity = $content[$i][$qtyPosition];

		$realStatus = '';
		if($statusPosition != 1000 && $content[$i][$statusPosition]) $realStatus = $content[$i][$statusPosition];

		$realCategory = 'default';
		if($categoryPosition != 1000 && $content[$i][$categoryPosition]) $realCategory = $content[$i][$categoryPosition];

		$realBarcode = '';
		if($barcodePosition != 1000 && $content[$i][$barcodePosition]) $realBarcode = $content[$i][$barcodePosition];

		$realIsstockable = 0;
		if($stockablePosition != 1000 && $content[$i][$stockablePosition]) $realIsstockable = $content[$i][$stockablePosition];
		

		$reqAdd = $bdd->prepare('INSERT INTO item(item_name, item_quantity, item_buy_price, item_price, item_barcode, item_icId, item_disabled, item_isstockable) VALUES(?,?,?,?,?,?,?,?)');
		$reqAdd->execute(array(htmlspecialchars($content[$i][$namePosition]),htmlspecialchars($realQuantity), htmlspecialchars($realBuyPrice),htmlspecialchars($realPrice), htmlspecialchars($realBarcode), htmlspecialchars($realCategory), htmlspecialchars($realStatus), htmlspecialchars($realIsstockable)));
		
		$newItemID = $bdd->lastInsertId();

		if($qtyPosition != 1000 && $content[$i][$qtyPosition]){


			if(htmlspecialchars($content[$i][$qtyPosition]) != 0){
				$reqSqa = $bdd->prepare('INSERT INTO stockquantityadjust(sqa_item_id,sqa_squantity,sqa_equantity,sqa_quantity, sqa_channel,sqa_time) VALUES(?,?,?,?,"mimport",NOW())');
				$reqSqa->execute(array(htmlspecialchars($newItemID), 0, htmlspecialchars($content[$i][$qtyPosition]), (htmlspecialchars($content[$i][$qtyPosition]))));

			}

		}
		
	}
	echo 'ok';
}
if(isset($_POST['maxUpdateCheck'])){

	
	$validCategories = [];
	$req = $bdd->query('SELECT * FROM itemcategory ORDER BY icId DESC');
	while($reqq = $req->fetch()){
		array_push($validCategories, $reqq['icId']);
	}
	
	$errors = [];

	$validHeaders = ['item_id','item_name','item_quantity','item_price','item_category','item_barcode','item_status','isstockable'];
	
	$extensions = strtolower(strrchr($_FILES['file']['name'], '.'));
	if($extensions == '.xlsx') $reader = new \PhpOffice\PhpSpreadsheet\Reader\Xlsx();
	else if($extensions == '.xls') $reader = new \PhpOffice\PhpSpreadsheet\Reader\Xls();
	else{
		echo '<li>The supported formats are xlsx and xls </li>';
		exit;
	}

	$file = $_FILES['file']['tmp_name'];
	$spreadsheet = $reader->load($file);

	$content = $spreadsheet->getSheet(0)->toArray();
	$headers = $content[0];

	if(!in_array('item_id',$headers)){
		echo '<li>Missing important column item_id</li>';
		exit;
	}

	// print_r($content);

	$idPosition = 1000;
	$namePosition =1000;
	$pricePosition =1000;
	$qtyPosition =1000;
	$categoryPosition =1000;
	$barcodePosition =1000;
	$statusPosition =1000;
	$stockablePosition =1000;

	if(in_array('item_id',$content[0])) $idPosition = array_search('item_id',$content[0]);
	if(in_array('item_name',$content[0])) $namePosition = array_search('item_name',$content[0]);
	if(in_array('item_quantity',$content[0])) $qtyPosition = array_search('item_quantity',$content[0]);
	if(in_array('item_price',$content[0])) $pricePosition = array_search('item_price',$content[0]);
	if(in_array('item_category',$content[0])) $categoryPosition = array_search('item_category',$content[0]);
	if(in_array('item_barcode',$content[0])) $barcodePosition = array_search('item_barcode',$content[0]);
	if(in_array('item_status',$content[0])) $statusPosition = array_search('item_status',$content[0]);
	if(in_array('isstockable',$content[0])) $stockablePosition = array_search('isstockable',$content[0]);

	
	
	foreach($headers as $header){
		if(!in_array($header,$validHeaders)){
			array_push($errors,'header "'.$header. '" is an invalid column');
		} 
	}

	for($i=1;$i< count($content);$i++){

		if($categoryPosition != 1000){
			if($content[$i][$categoryPosition] AND !in_array($content[$i][$categoryPosition],$validCategories)){
				array_push($errors,'Category "'.$content[$i][$categoryPosition]. '" is an invalid category on line '.($i+1));
			}
		}
		if($statusPosition != 1000){
			if($content[$i][$statusPosition] AND $content[$i][$statusPosition] != 'disabled'){
				array_push($errors,'"'.$content[$i][$statusPosition]. '" is not valid status on line '.($i+1));
			}
		}
		if($pricePosition != 1000){
			if($content[$i][$pricePosition] AND !is_numeric($content[$i][$pricePosition])){
				array_push($errors,'"'.$content[$i][$pricePosition]. '" is not valid price on line '.($i+1));
			}
		}
		if($qtyPosition != 1000){
			if($content[$i][$qtyPosition] AND !is_numeric($content[$i][$qtyPosition])){
				array_push($errors,'"'.$content[$i][$qtyPosition]. '" is not valid quantity on line '.($i+1));
			}
		}

		if($stockablePosition != 1000){
			if($content[$i][$stockablePosition] AND !in_array($content[$i][$stockablePosition],[0,1])){
				array_push($errors,'isstockable column value must be 0 or 1 on line '.($i+1));
			}
		}
		
	}


	if(count($errors) > 0){
		foreach($errors as $error){
			echo '<li>'.$error.'</li>';
		}
		exit;
	}

	echo 'pass';
}
if(isset($_POST['maxUpdateUpload'])){
	
	$extensions = strtolower(strrchr($_FILES['file']['name'], '.'));
	if($extensions == '.xlsx') $reader = new \PhpOffice\PhpSpreadsheet\Reader\Xlsx();
	else if($extensions == '.xls') $reader = new \PhpOffice\PhpSpreadsheet\Reader\Xls();

	$file = $_FILES['file']['tmp_name'];
	$spreadsheet = $reader->load($file);

	$content = $spreadsheet->getSheet(0)->toArray();
	$headers = $content[0];

	$idPosition = 1000;
	$namePosition =1000;
	$pricePosition =1000;
	$qtyPosition =1000;
	$categoryPosition =1000;
	$barcodePosition =1000;
	$statusPosition =1000;
	$stockablePosition =1000;

	if(in_array('item_id',$content[0])) $idPosition = array_search('item_id',$content[0]);
	if(in_array('item_name',$content[0])) $namePosition = array_search('item_name',$content[0]);
	if(in_array('item_quantity',$content[0])) $qtyPosition = array_search('item_quantity',$content[0]);
	if(in_array('item_price',$content[0])) $pricePosition = array_search('item_price',$content[0]);
	if(in_array('item_category',$content[0])) $categoryPosition = array_search('item_category',$content[0]);
	if(in_array('item_barcode',$content[0])) $barcodePosition = array_search('item_barcode',$content[0]);
	if(in_array('item_status',$content[0])) $statusPosition = array_search('item_status',$content[0]);
	if(in_array('isstockable',$content[0])) $stockablePosition = array_search('isstockable',$content[0]);
	
	for($i=1;$i< count($content);$i++){

		$nameUpdateQuery = '';
		if($namePosition != 1000 && $content[$i][$namePosition]){
			$nameUpdateQuery = ',item_name = :item_name';
		}
		$priceUpdateQuery = '';
		if($pricePosition != 1000 && $content[$i][$pricePosition]){
			$priceUpdateQuery = ',item_price = :item_price';
		}

		$quantityUpdateQuery = '';
		if($qtyPosition != 1000 && $content[$i][$qtyPosition]){
			$quantityUpdateQuery = ',item_quantity = :item_quantity';
		}

		$categoryUpdateQuery = '';
		if($categoryPosition != 1000 && $content[$i][$categoryPosition]){
			$categoryUpdateQuery = ',item_icId = :item_category';
		}

		$statusUpdateQuery = '';
		if($statusPosition != 1000 && $content[$i][$statusPosition]){
			$statusUpdateQuery = ',item_disabled = :item_status';
		}

		$barcodeUpdateQuery = '';
		if($barcodePosition != 1000 && $content[$i][$barcodePosition]){
			$barcodeUpdateQuery = ',item_barcode = :item_barcode';
		}

		$isstockableUpdateQuery = '';
		if($stockablePosition != 1000 && $content[$i][$stockablePosition]){
			$isstockableUpdateQuery = ',item_isstockable = :item_isstockable';
		}


		if($qtyPosition != 1000 && $content[$i][$qtyPosition]){

			$reqSelect = $bdd->prepare('SELECT item_quantity FROM item WHERE item_id = ?');
			$reqSelect->execute(array(htmlspecialchars($content[$i][$idPosition])));
			$reqqSelect = $reqSelect->fetch();
			

			if(htmlspecialchars($content[$i][$qtyPosition]) != htmlspecialchars($reqqSelect['item_quantity'])){
				$reqSqa = $bdd->prepare('INSERT INTO stockquantityadjust(sqa_item_id,sqa_squantity,sqa_equantity,sqa_quantity,sqa_channel,sqa_time) VALUES(?,?,?,?,"mupdate",NOW())');
				$reqSqa->execute(array(htmlspecialchars($content[$i][$idPosition]), htmlspecialchars($reqqSelect['item_quantity']), htmlspecialchars($content[$i][$qtyPosition]), (htmlspecialchars($content[$i][$qtyPosition]) - htmlspecialchars($reqqSelect['item_quantity']))));

			}

		}
		
		
		$reqUpdate = $bdd->prepare('UPDATE item SET item_id = :item_id '.$nameUpdateQuery.' '.$priceUpdateQuery.' '.$quantityUpdateQuery.' '.$categoryUpdateQuery.' '.$statusUpdateQuery.' '.$barcodeUpdateQuery.' '.$isstockableUpdateQuery.' WHERE item_id = :item_idd');

		$reqUpdate->bindParam(':item_id', $content[$i][$idPosition], PDO::PARAM_STR, 12);
		$reqUpdate->bindParam(':item_idd', $content[$i][$idPosition], PDO::PARAM_STR, 12);
		if($namePosition != 1000 && $content[$i][$namePosition]) $reqUpdate->bindParam(':item_name', $content[$i][$namePosition], PDO::PARAM_STR, 12);
		
		if($pricePosition != 1000 && $content[$i][$pricePosition]) $reqUpdate->bindParam(':item_price', $content[$i][$pricePosition], PDO::PARAM_STR, 12);

		if($qtyPosition != 1000 && $content[$i][$qtyPosition]) $reqUpdate->bindParam(':item_quantity', $content[$i][$qtyPosition], PDO::PARAM_STR, 12);
		
		if($categoryPosition != 1000 && $content[$i][$categoryPosition]) $reqUpdate->bindParam(':item_category', $content[$i][$categoryPosition], PDO::PARAM_STR, 12);
		
		if($statusPosition != 1000 && $content[$i][$statusPosition]) $reqUpdate->bindParam(':item_status', $content[$i][$statusPosition], PDO::PARAM_STR, 12);
		
		if($barcodePosition != 1000 && $content[$i][$barcodePosition]) $reqUpdate->bindParam(':item_barcode', $content[$i][$barcodePosition], PDO::PARAM_STR, 12);

		if($stockablePosition != 1000 && $content[$i][$stockablePosition]) $reqUpdate->bindParam(':item_isstockable', $content[$i][$stockablePosition], PDO::PARAM_STR, 12);
		
		
		$reqUpdate->execute();
		
	}
	echo 'ok';
}

if(isset($_POST['maxStockLoad'])){
	
	$extensions = strtolower(strrchr($_FILES['file']['name'], '.'));
	if($extensions == '.xlsx') $reader = new \PhpOffice\PhpSpreadsheet\Reader\Xlsx();
	else if($extensions == '.xls') $reader = new \PhpOffice\PhpSpreadsheet\Reader\Xls();

	$file = $_FILES['file']['tmp_name'];
	$spreadsheet = $reader->load($file);

	$content = $spreadsheet->getSheet(0)->toArray();
	$headers = $content[0];

	$idPosition = 1000;
	$qtyPosition =1000;

	if(in_array('item_id',$content[0])) $idPosition = array_search('item_id',$content[0]);
	if(in_array('item_quantity',$content[0])) $qtyPosition = array_search('item_quantity',$content[0]);
	
	
	for($i=1;$i< count($content);$i++){

		


		if($idPosition != 1000 && $content[$i][$idPosition]){
			if($qtyPosition != 1000 && $content[$i][$qtyPosition]){
				
				$reqSelect = $bdd->prepare('SELECT item_quantity FROM item WHERE item_id = ?');
				$reqSelect->execute(array(htmlspecialchars($content[$i][$idPosition])));
				$reqqSelect = $reqSelect->fetch();

				
				$endQty = htmlspecialchars($content[$i][$qtyPosition]) + htmlspecialchars($reqqSelect['item_quantity']);

				if(htmlspecialchars($content[$i][$qtyPosition]) != 0){
					$reqSqa = $bdd->prepare('INSERT INTO stockquantityadjust(sqa_item_id,sqa_squantity,sqa_equantity,sqa_quantity,sqa_channel,sqa_time) VALUES(?,?,?,?,"stockloading",NOW())');
					$reqSqa->execute(array(htmlspecialchars($content[$i][$idPosition]), htmlspecialchars($reqqSelect['item_quantity']), $endQty, htmlspecialchars($content[$i][$qtyPosition])));

					
					$reqUpdate = $bdd->prepare('UPDATE item SET item_quantity = :endQty WHERE item_id = :item_id');

					$reqUpdate->bindParam(':item_id', $content[$i][$idPosition], PDO::PARAM_STR, 12);
					$reqUpdate->bindParam(':endQty', $endQty, PDO::PARAM_STR, 12);
					
					$reqUpdate->execute();
				}

			}
		}
	}

	echo 'ok';
	
}
