<?php
session_start();
if(!isset($_SESSION['username'])){
	header('location:login.php');
	exit;
}
include('../../postfolder/connexion.php');

require '../../vendor/vendor/autoload.php';

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xls;



	$cancelledOrdersQuery = 'AND sa_cancelled != "Y" ';
	if($_GET['refund'] == 'yes') $cancelledOrdersQuery = '';
	$refundVar = htmlspecialchars($_GET['refund']);
	
	
	$startDate= htmlspecialchars($_GET['startDate']);
	$endDate = htmlspecialchars($_GET['endDate']);
	$item_id = htmlspecialchars($_GET['item_id']);
	
$req = $bdd->prepare('SELECT sI.sa_id, sa_item_id, saI_quantity, sa_date, sa_time, s_name,sa_totalPrice FROM salesitem sI LEFT JOIN sales sa ON sI.sa_id = sa.sa_id LEFT JOIN workers s ON s.ID = sa.sa_s_ID WHERE sa_item_id = :item_id AND sa_date >= :startdate AND sa_date <= :endDate '.$cancelledOrdersQuery.' ');

			$req->bindParam(':item_id', $item_id, PDO::PARAM_STR, 12);
			$req->bindParam(':startdate', $startDate, PDO::PARAM_STR, 12);
			$req->bindParam(':endDate', $endDate, PDO::PARAM_STR, 12);
			$req->execute();
	

    $data = [];

    while($reqq = $req->fetch()){
    	$line = [
			'orderNo' => $reqq['sa_id'],
			'totalPrice' => $reqq['sa_totalPrice'],
			'itemID' => $reqq['sa_item_id'],
			'qty' => $reqq['saI_quantity'],
			'salePerson' => $reqq['s_name'],
			'date' => $reqq['sa_date'],
			'time' => $reqq['sa_time']

		];
		array_push($data, $line);
	}

$spreadsheet = new Spreadsheet();
$sheet = $spreadsheet->getActiveSheet(0);

$sheet->setCellValue('A1', 'ORDER NUMBER');
$sheet->setCellValue('B1', 'ORDER TOTAL PRICE');
$sheet->setCellValue('C1', 'ITEM ID');
$sheet->setCellValue('D1', 'QTY');
$sheet->setCellValue('E1', 'SALE PERSON');
$sheet->setCellValue('F1', 'DATE');
$sheet->setCellValue('G1', 'PRICE');


$rowNo = 2;

	foreach ($data as $row) {
		$sheet->setCellValue('A'.$rowNo, $row['orderNo']);
		$sheet->setCellValue('B'.$rowNo, $row['totalPrice']);
		$sheet->setCellValue('C'.$rowNo, $row['itemID']);
		$sheet->setCellValue('D'.$rowNo, $row['qty']);
		$sheet->setCellValue('E'.$rowNo,$row['salePerson']);
		$sheet->setCellValue('F'.$rowNo,$row['date']);
		$sheet->setCellValue('G'.$rowNo,$row['time']);
		
		$rowNo++;
	}

$fileName = 'itemdetails_sales.xls';
header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header('Content-Disposition: attachment; filename="'. urlencode($fileName).'"');
$writer = new Xls($spreadsheet);
$writer->save('php://output');
