<?php
session_start();
if(!isset($_SESSION['username'])){
	header('location:login.php');
	exit;
}
include('../../postfolder/connexion.php');

require '../../vendor/vendor/autoload.php';

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xls;



	$cancelledOrdersQuery = 'AND sa_cancelled != "Y" ';
	if(isset($_POST['refund'])) $cancelledOrdersQuery = '';

	$startDate= htmlspecialchars($_POST['startDate']);
	$endDate = htmlspecialchars($_POST['endDate']);
	
$req = $bdd->prepare('SELECT iCName, sa_item_id, unit_price, COUNT(sI.sa_id) as nbOrder, SUM(saI_quantity) As qty, item_name, item_icId FROM salesitem sI LEFT JOIN item i ON i.item_id = sI.sa_item_id LEFT JOIN sales sa ON sa.sa_id = sI.sa_id LEFT JOIN itemcategory ic ON item_icId = icId WHERE sa_date >= :startdate AND sa_date <= :endDate '.$cancelledOrdersQuery.' GROUP BY sa_item_id'); /*ORDER BY sa_id DESC*/

$req->bindParam(':startdate', $startDate, PDO::PARAM_STR, 12);
$req->bindParam(':endDate', $endDate, PDO::PARAM_STR, 12);
$req->execute();
	

    $data = [];

    while($reqq = $req->fetch()){
    	$line = [
			'itemID' => $reqq['sa_item_id'],
			'itemName' => $reqq['item_name'],
			'category' => $reqq['iCName'],
			'qty' => $reqq['qty'],
			'orderCount' => $reqq['nbOrder']
		];
		array_push($data, $line);
	}

$spreadsheet = new Spreadsheet();
$sheet = $spreadsheet->getActiveSheet(0);

$sheet->setCellValue('A1', 'ITEM ID');
$sheet->setCellValue('B1', 'ITEM NAME');
$sheet->setCellValue('C1', 'CATEGORY NAME');
$sheet->setCellValue('D1', 'QTY');
$sheet->setCellValue('E1', 'ORDER COUNT');


$rowNo = 2;

	foreach ($data as $row) {
		$sheet->setCellValue('A'.$rowNo, $row['itemID']);
		$sheet->setCellValue('B'.$rowNo, $row['itemName']);
		$sheet->setCellValue('C'.$rowNo, $row['category']);
		$sheet->setCellValue('D'.$rowNo, $row['qty']);
		$sheet->setCellValue('E'.$rowNo,$row['orderCount']);
		
		$rowNo++;
	}

$fileName = 'item_sales.xls';
header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header('Content-Disposition: attachment; filename="'. urlencode($fileName).'"');
$writer = new Xls($spreadsheet);
$writer->save('php://output');
	