<?php
session_start();
if(!isset($_SESSION['username'])){
	header('location:login.php');
	exit;
}
include('../../postfolder/connexion.php');

require '../../vendor/vendor/autoload.php';

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xls;


	

	$recorder = $_POST['cashier'];
			$staffs = $_POST['staffs'];
			$startDate= htmlspecialchars($_POST['startDate']);
    		$endDate = htmlspecialchars($_POST['endDate']);

	$recorder = '%'.$recorder.'%';
	$staffs = '%'.$staffs.'%';

	$startTime = $startDate.' 00:00:00';
	$endTime = $endDate.' 23:59:59';

	$req = $bdd->prepare('SELECT pc_staff_id, pc_amount, pc_reason, pc_date, ww.s_name As ss, w.s_name as se FROM pettycash LEFT JOIN  workers ww ON ww.ID = pc_staff_id LEFT JOIN workers w ON w.ID = pc_recording_staffs  WHERE pc_recording_staffs LIKE :ID AND pc_staff_id LIKE :staffs AND pc_date >= :startdate AND pc_date <= :endDate ORDER BY pc_date DESC ');
	$req->bindParam(':ID', $recorder, PDO::PARAM_STR, 12);
	$req->bindParam(':staffs', $staffs, PDO::PARAM_STR, 12);
	$req->bindParam(':startdate', $startTime, PDO::PARAM_STR, 12);
	$req->bindParam(':endDate', $endTime, PDO::PARAM_STR, 12);
	$req->execute();
	

    $data = [];

    
	
    while($reqq = $req->fetch()){
    	$line = [
			'pc_staff_id' => $reqq['pc_staff_id'],
			'staffName' => $reqq['ss'],
			'amount' => $reqq['pc_amount'],
			'reason' => $reqq['pc_reason'],
			'date' => $reqq['pc_date'],
			'recordingStaff' => $reqq['se'],
			
		];
		array_push($data, $line);
	}

$spreadsheet = new Spreadsheet();
$sheet = $spreadsheet->getActiveSheet(0);

$sheet->setCellValue('A1', 'Staff ID');
$sheet->setCellValue('B1', 'Staff Name');
$sheet->setCellValue('C1', 'Amount');
$sheet->setCellValue('D1', 'Reason');
$sheet->setCellValue('E1', 'Date/time');
$sheet->setCellValue('F1', 'Rcording Staff');


$rowNo = 2;

	foreach ($data as $row) {
		$sheet->setCellValue('A'.$rowNo, $row['pc_staff_id']);
		$sheet->setCellValue('B'.$rowNo, $row['staffName']);
		$sheet->setCellValue('C'.$rowNo, $row['amount']);
		$sheet->setCellValue('D'.$rowNo, $row['reason']);
		$sheet->setCellValue('E'.$rowNo, $row['date']);
		$sheet->setCellValue('F'.$rowNo, $row['recordingStaff']);
		$rowNo++;
	}

$fileName = 'pettycash_export.xls';
header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header('Content-Disposition: attachment; filename="'. urlencode($fileName).'"');
$writer = new Xls($spreadsheet);
$writer->save('php://output');
	