<?php
session_start();
if(!isset($_SESSION['username'])){
	header('location:login.php');
	exit;
}
include('../../postfolder/connexion.php');

require '../../vendor/vendor/autoload.php';

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xls;


	$paymentMode = [
		'cash' => 'Cash',
		'mobile' => 'Mobile Money',
		'credit' => 'Credit Card'
	];

	

	$cancelledOrdersQuery = 'AND sa_cancelled != "Y" ';
	if(isset($_POST['refund'])) $cancelledOrdersQuery = '';

	$cashier = $_POST['cashier'];
	$startDate= htmlspecialchars($_POST['startDate']);
	$endDate = htmlspecialchars($_POST['endDate']);
	$payMode = htmlspecialchars($_POST['paymentMode']);

	$cashier = '%'.$cashier.'%';
	$payMode = '%'.$payMode.'%';

	$req = $bdd->prepare('SELECT * FROM sales sa, workers s WHERE sa_s_ID = s.ID AND sa_s_ID LIKE :ID AND sa_date >= :startdate AND sa_date <= :endDate AND payment_method LIKE :payMode '.$cancelledOrdersQuery.' ');

	$req->bindParam(':ID', $cashier, PDO::PARAM_STR, 12);
	$req->bindParam(':startdate', $startDate, PDO::PARAM_STR, 12);
	$req->bindParam(':endDate', $endDate, PDO::PARAM_STR, 12);
	$req->bindParam(':payMode', $payMode, PDO::PARAM_STR, 12);
	$req->execute();
	

    $data = [];

    
	
    while($reqq = $req->fetch()){
    	$line = [
			'orderNumber' => $reqq['sa_id'],
			'itemQTY' => $reqq['sa_itemQuantity'],
			'totalPrice' => $reqq['sa_totalPrice'],
			'name' => $reqq['s_name'],
			'paymentMode' => $reqq['payment_method'],
			'date' => $reqq['sa_date'],
			'time' => $reqq['sa_time'],
			'sa_cancelled' => $reqq['sa_cancelled']
		];
		array_push($data, $line);
	}

$spreadsheet = new Spreadsheet();
$sheet = $spreadsheet->getActiveSheet(0);

$sheet->setCellValue('A1', 'ORDER NUMBER');
$sheet->setCellValue('B1', 'TOTAL QTY');
$sheet->setCellValue('C1', 'TOTAL PRICE');
$sheet->setCellValue('D1', 'CASHIER NAME');
$sheet->setCellValue('E1', 'PAYMENT MODE');
$sheet->setCellValue('F1', 'DATE');
$sheet->setCellValue('G1', 'TIME');
if(isset($_POST['refund'])){ $sheet->setCellValue('H1', 'CANCELLED?'); }


$rowNo = 2;

	foreach ($data as $row) {
		$sheet->setCellValue('A'.$rowNo, $row['orderNumber']);
		$sheet->setCellValue('B'.$rowNo, $row['itemQTY']);
		$sheet->setCellValue('C'.$rowNo, $row['totalPrice']);
		$sheet->setCellValue('D'.$rowNo, $row['name']);
		$sheet->setCellValue('E'.$rowNo, $paymentMode[$row['paymentMode']]);
		$sheet->setCellValue('F'.$rowNo, $row['date']);
		$sheet->setCellValue('G'.$rowNo, $row['time']);
		if(isset($_POST['refund'])){ $sheet->setCellValue('H'.$rowNo, $row['sa_cancelled']); }
		$rowNo++;
	}

$fileName = 'sales_export.xls';
header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header('Content-Disposition: attachment; filename="'. urlencode($fileName).'"');
$writer = new Xls($spreadsheet);
$writer->save('php://output');
	