<?php
session_start();
	if(!isset($_SESSION['username'])){
		header('location:login.php');
		exit;
	}

	if(!isset($_GET['ID'])){
		header('location:salaryInfo.php');
		exit;
	}
	include('../postfolder/connexion.php');

	$req = $bdd->prepare('SELECT * FROM workersIncome WHERE wi_userID = ?');
	$req->execute(array($_GET['ID']));
	$reqq = $req->fetch();

	$reqOvertimeRate = $bdd->query('SELECT overtimeRate FROM salaryInfo');
	$reqqOvertimeRate = $reqOvertimeRate->fetch();

?>
<!DOCTYPE html>
<html>
<head>
	<link rel="stylesheet" href="../css/staffStyle.css?v=<?php time() ?>">
	<link rel="stylesheet" href="../css/font-awesome/css/font-awesome.min.css">
	<title></title>
<style>
	#lastPayDiv span{
		display:inline-block;
		margin-right: 20px;
		font-size: 18px;
	}
	input{
		width:200px;
		padding: 5px;
	}
	input[type=submit]{
		width: unset;

	}
	#div{
		width: 600px;
	}
	#div span{
		display:inline-block;
		margin:10px;
		width: 200px;
	}
	#div span:nth-child(odd){
		font-weight: bold;
	}
	#payBut{
		padding:5px 10px;
	}
	#flexDiv{
		display: flex;
		justify-content: left;
		flex-wrap: wrap;
		margin: 40px 10px;
		padding: 20px;
		background-color: white;
	}
	#flexDiv > div{
		width: 50%;
		margin-bottom: 20px;
	}
	
	#flexDiv > div span{
		font-size: 20px;
		font-weight: bold;
	}
</style>
</head>
<body>

	<?php include('header.php'); ?>
<section>

	<h2>Last pay</h2>
	<?php
		$rqLastPay = $bdd -> prepare('SELECT salary_id,salary_amount, salary_time FROM salary WHERE salary_userID = ? ORDER BY salary_id DESC LIMIT 1');
		$rqLastPay->execute(array($_GET['ID']));
		$rqqLastPay = $rqLastPay->fetch();
		if($rqLastPay->rowCount() >0){
		?>
		<div id='lastPayDiv'>
			<span><strong>Amount: </strong> <?php echo $rqqLastPay['salary_amount'] ;?></span>
			<span><strong>Date and time: </strong> <?php echo aDateU($rqqLastPay['salary_time']).' - '.aTimeU($rqqLastPay['salary_time'])  ;?></span>
			<span>
				<a href='payDetails.php?salary_id=<?php echo $rqqLastPay["salary_id"];?> '><i class="fa fa-plus"></i></a>
			</span>

		</div>

	<?php
		}else{
			echo 'No pay for now.';
		}
			if(isset($_GET['error'])){
				?>
				<p class="error">
					<?php echo $_GET['error'];?>
				</p>
				<?php
			}
			else if(isset($_GET['success'])){
				?>
				<p class="success">
					<?php echo $_GET['success'];?>
				</p>
				<?php
			}
			?>
<div id='flexDiv'>
	<div>
		<h3>Add an overtime</h3>
		<form method='post' action='postfolder/salaryOperations.php'>
			<input type='hidden' name='overtime'>
			<input type='hidden' name='ID' value="<?php echo $_GET['ID'];?>">
			<input type="number" placeholder="Enter the hour of overtime" name='numberOfTime'>
			<input type="submit" value="Add">
		</form>

			<p>The overtime rate per hour is 15 GHS</p>
		<h3>Number of overtime</h3>

		<?php
			$reqOvertime = $bdd->prepare('SELECT SUM(o_numberOfTimes) As numberOfTimes FROM overtimeRecord WHERE o_s_userID = ? AND o_check != "Check" ');
			$reqOvertime->execute(array($_GET['ID']));
			$reqqOvertime = $reqOvertime->fetch();

			if($reqqOvertime['numberOfTimes'] == 0  || !$reqqOvertime['numberOfTimes'] > 0) {
				$reqqOvertime['numberOfTimes'] = 0;
			}
			?>
			<?php
			echo '<span>'.$reqqOvertime['numberOfTimes'].'</span>';

			
		?>
	</div>

	<div>
		<h3>Add bonus</h3>
		<form method='post' action='postfolder/salaryOperations.php'>
			<input type='hidden' name='bonus'>
			<input type='hidden' name='ID' value="<?php echo $_GET['ID'];?>">
			<input type="number" name='bonusAmount'>
			<input type="submit" value="Add">
		</form>
		<h3>Current bonus</h3>
		<?php
			$reqBonus = $bdd->prepare('SELECT SUM(b_amount) As amount FROM bonus WHERE b_s_userID = ? AND b_check != "Check" ');
			$reqBonus->execute(array($_GET['ID']));
			$reqqBonus = $reqBonus->fetch();
			if($reqqBonus['amount'] == 0  || !$reqqBonus['amount'] > 0) {
				$reqqBonus['amount'] = 0;
			}
			echo '<span>'.$reqqBonus['amount'].'</span>';
		?>
	</div>

	<div>

	<h3>Loans</h3>
		<form method='post' action='postfolder/salaryOperations.php'>
			<input type='hidden' name='loan'>
			<input type='hidden' name='ID' value="<?php echo $_GET['ID'];?>">
			<input type="number" name='loanAmount'>
			<input type="submit" value="Add">
		</form><br>
		<?php
			$reqDeduction = $bdd->prepare('SELECT SUM(d_amount) As amount FROM deduction WHERE d_s_userID = ? ');
			$reqDeduction->execute(array($_GET['ID']));
			$reqqDeduction = $reqDeduction->fetch();
			if($reqqDeduction['amount'] == 0  || !$reqqDeduction['amount'] > 0) {
				$reqqDeduction['amount'] = 0;
			}
			echo 'Current loan amount: <span>'. $reqqDeduction['amount'].'</span><br>';
		?>

		<br>Deduction amount: <input type="number" id='deductionInput' max="<?php echo $reqqDeduction['amount'];?>">
	</div>

</div>

<div  style='font-size: 19px;'>
	<h2>Salary Payment</h2>
	<?php
	//Calculation
		$basicSalary = (int)$reqq['wi_income'];
		$taxes = (int)(($reqq['wi_income']*5.5)/100);
		$overtimeMoney = $reqqOvertime['numberOfTimes']*15;
		$bonusAmount = $reqqBonus['amount'];
		$netPays = $basicSalary - $taxes + $overtimeMoney + $bonusAmount;
		?>
	<div id='div'>
		<span>Basic salary:</span> <span id='basicPay'> <?php echo $reqq['wi_income']; ?></span>
		<span>Taxes:</span> <span id='taxes'> <?php echo $taxes; ?></span> 
		<span>Bonus:</span> <span id='bonusAmount'> <?php echo $bonusAmount; ?></span> 
		<?php if($reqqDeduction['amount'] >0){?> <span>Current loan:</span> <span id='cLoan'> <?= $reqqDeduction['amount']?></span><?php } ?>
		<span>Deduction:</span> <span id='Deductions'> 0</span>
		<span>OvertimeMoney:</span> <span id='overtimeMoney'> <?php echo $overtimeMoney; ?></span> 
		<span>Net pay:</span><span id='pay'> <?php echo $netPays; ?></span>
	</div>
	<br><button id='payBut'>Pay</button>
</div>
</section>
	<?php include('footer.php'); ?>
	<span id='ID' style="display:none"><?php echo $_GET['ID'] ?></span>
	<span id='netP' style="display:none"><?php echo $netPays ?></span>
<script type="text/javascript">
	var netPa = parseInt($(netP).text())
	var max = $(deductionInput).attr('max')

	$(payBut).click(function(){
		var val = parseInt($(deductionInput).val());
		if(val > max ){
			alert('the total loan is '+max)
			$(deductionInput).val(max)
			return false;
		}
			var data = {
        		pay: 'ok',
        		payAmount: parseInt($(pay).text()),
        		paybackAmount: - $(deductionInput).val(),
        		basicPay: parseInt($(basicPay).text()),
        		bonusAmount: parseInt($(bonusAmount).text()),
				cLoan: parseInt($(cLoan).text()),
        		overtimeMoney: parseInt($(overtimeMoney).text()),
        		taxes: parseInt($(taxes).text()),
        		ID:$(ID).text(),       		
        	}
				$.ajax({
                    url:'postfolder/salaryOperations.php',
                    type:'post',
                    data:data,
                    dataType:'text',
                    success: function(donne,statut){
                    	if(donne.trim() == 'ok') {
                    		alert('Payment successful')
                    		location.href = 'salaryDetails.php?ID='+$(ID).text()
                    	}
                    	else console.log(donne)
                    }
                })
	})

$(deductionInput).on('change keyup',function(){

	var deductionInputValue = parseInt($(this).val())
	if(deductionInputValue == 0 || !deductionInputValue > 0) deductionInputValue = 0
	var netPays = netPa-deductionInputValue
	$(Deductions).text(deductionInputValue)
	$(pay).text(netPays)
})
</script>
</body>
</html>