<?php
session_start();
if(!isset($_SESSION['username'])){
	header('location:login.php');
	exit;
}
	

include('../postfolder/connexion.php');
?>
<!DOCTYPE html>
<html>
<head>
	<link rel="stylesheet" href="../css/staffStyle.css?v=<?php time() ?>">
    <link rel="stylesheet" href="../css/font-awesome/css/font-awesome.min.css">
    <link id="bs-css" href="../css/jqD.css" rel="stylesheet">
	<title></title>
<style>
	
	#table{
		width: 80%;
		margin:auto;
		margin-top:20px;
		border-collapse: collapse;
	}
	th{
		border:1px solid #aaa;
	}
	td{
		border:1px solid #aaa;
	}
	.dataTables_wrapper .dataTables_length, .dataTables_wrapper .dataTables_filter, .dataTables_wrapper .dataTables_info, .dataTables_wrapper .dataTables_processing, .dataTables_wrapper .dataTables_paginate{
		margin:20px;
	}


	input[type=date]{
		line-height: 30px;
		position: relative;
		bottom: 1px;
		font-weight: bold;
		width: 139px;
	}

	#iSearchResult{
		display:block;
	}
	
	td,th{
		text-align: center;
		padding:10px;
	}
	#gen{
		font-size: 90%;
	}
	#aa{
		text-decoration: none;
		border:2px solid black;
		padding:8px 3px;
		color:black;
		font-weight: bold;
		margin-top:20px;
		display:inline-block;
	}
	#dateRadio label{
		display: unset;
	} 

	.aaa{
		text-decoration: none;
		border: 1px solid black;
		padding: 8px 10px;
		color: black;
		margin-top: 20px;
		display: inline-block;
		margin-bottom: 20px;
	}
	#aaaActive{
		border: 1px solid #7baa2f;
		color: #7baa2f;
		padding: 8px 10px;
	}  
	#summaryDiv span{
		display: block;
		margin-bottom: 10px;
	}
</style>
</head>
<body>
	<?php include('header.php'); ?>
<section>

	<a id="aaaActive" href='#'>Sales report</a>
	<a class='aaa' href='itemreport.php'>Item report</a>

	
	<?php

		$paymentMode = [
			'cash' => 'Cash',
			'mobile' => 'Mobile Money',
			'credit' => 'Credit Card'
		];
		// print($paymentMode['credit']);

			$date=date_create(date('Y-m-d'));
          	

		$cashier = '';
        $startDate = date_format($date,"Y-m-d");
        $endDate = date("Y-m-d");
        $payMode = '';


         if(isset($_POST['cashier'])){
			$cashier = $_POST['cashier'];
			$startDate= htmlspecialchars($_POST['startDate']);
    		$endDate = htmlspecialchars($_POST['endDate']);
    		$payMode = htmlspecialchars($_POST['paymentMode']);
    	}

	    

	?>
	<form  style='display: none' id='exportForm' method='post' action='postfolder/salessExport.php'>
		<input type="text" id="cashierA" name="cashier" >
		<input type="text" id="paymentModeA" name="paymentMode" >
		<input type="date" id='startDateA' name="startDate">
		<input type="date" id='endDateA' name="endDate">
		<input type="checkbox" name="refund" id='refundA' <?php if(isset($_POST['refund'])){ echo 'checked';} ?>>
		<input type='submit' value='submit'>
	</form>
	
	<form id='filter' method='post' action='sales.php'>
		<select name='cashier' id='cashier'>
			<option value=''>All cashiers</option>
			<?php
				$reqWorker = $bdd->query('SELECT * FROM workers where s_category = "cashier" ORDER BY ID ');

				while($reqWorkers = $reqWorker->fetch()){ 
					$selected = '';

					if($reqWorkers['ID'] == $cashier) $selected = 'selected';
					?>
					<option value="<?php echo $reqWorkers['ID'];?>" <?= $selected ?>><?php echo $reqWorkers['s_name'];?></option>
				<?php }
			?>
		</select>
		<select name='paymentMode' id='paymentMode'>
			<option value=''>All payment</option>
			<?php
				foreach($paymentMode as $key =>$value){
					$selected = '';

					if($key == $payMode)  $selected = 'selected';
					?>
					<option value="<?= $key ?>" <?= $selected ?>><?= $value ?></option>
				<?php }
			?>
			
		</select>
		<input type='date' name='startDate' id='startDate' value="<?= $startDate ?>">
		<input type='date' name='endDate' id='endDate' value="<?= $endDate ?>">
		<input type="checkbox" name="refund" id='refund' <?php if(isset($_POST['refund'])){ echo 'checked';} ?>> <label style='display: inline-block;' for='refund'>Include cancelled orders</label>
		<input style='padding:5px 25px' type="submit" value='Filter'>
	</form>
	<button id='export' style='display:block; margin-bottom: 20px; cursor:pointer'>
		Export in Excel
	</button>
	
	<div style='margin-top:30px'>
		<?php 

			
			$cancelledOrdersQuery = 'AND sa_cancelled != "Y" ';
			if(isset($_POST['refund'])) $cancelledOrdersQuery = '';

			$cashier = '%'.$cashier.'%';
			$payMode = '%'.$payMode.'%';

			$i = 1;

			$req = $bdd->prepare('SELECT * FROM sales sa, workers s WHERE sa_s_ID = s.ID AND sa_s_ID LIKE :ID AND sa_date >= :startdate AND sa_date <= :endDate AND payment_method LIKE :payMode '.$cancelledOrdersQuery.' '); /*ORDER BY sa_id DESC*/

			$req->bindParam(':ID', $cashier, PDO::PARAM_STR, 12);
			$req->bindParam(':startdate', $startDate, PDO::PARAM_STR, 12);
			$req->bindParam(':endDate', $endDate, PDO::PARAM_STR, 12);
			$req->bindParam(':payMode', $payMode, PDO::PARAM_STR, 12);
			$req->execute();


			?>
		<table id='table'>
		<thead>
			<tr>
				<th>N•</th>
				<th>Order No</th>
				<th>Total Quantity</th>
				<th>Total Price</th>
				<th>Sale person</th>
				<th>Payment Mode</th>
				<th>Sales Date</th>
				<th>Sales time</th>
				<?php if(isset($_POST['refund'])){ ?> <th>Cancelled?</th> <?php } ?>
				<td>Actions</td>
			</tr>
		</thead>
		<tbody>
			<?php
			$totalPRice = 0;
			$totalQty = 0;
			$totalStockAffectedSold = 0;
			$totalSalesBuyingCost = 0;
			while($reqq = $req->fetch()){
					$totalPRice = $totalPRice + $reqq['sa_totalPrice'];
					$totalQty = $totalQty + $reqq['sa_itemQuantity'];
					$totalStockAffectedSold += $reqq['sa_totalQtyAffected'];
					$totalSalesBuyingCost += $reqq['sa_totalSalesBuyingCost'];

				?>
				<tr>

					<td><?php echo $i;?></td>
					<td><?php echo $reqq['sa_id'];?></td>
					<td><?php echo $reqq['sa_itemQuantity'];?></td>
					<td><?php echo $reqq['sa_totalPrice'];?></td>
					<td><?php echo $reqq['s_name'];?></td>
					<td><?php echo $paymentMode[$reqq['payment_method']];?></td>
					<td><?php echo aDateU($reqq['sa_date']);?></td>
					<td><?php echo aTimeU($reqq['sa_time']);?></td>
					<?php if(isset($_POST['refund'])){ echo '<td>'.$reqq['sa_cancelled'].'</td>'; } ?>
					<td><a class='actionButtonI' target="_blank" href="salesDetails.php?sa_id=<?php echo $reqq['sa_id'];?>"><i class='fa fa-plus'></i></a></td>
				</tr>
				<?php
				$i++;
			}


			?>
		</tbody>
		</table>
		<div id='summaryDiv' >
			<span><strong>Total sale amount</strong>: GHC <?= $totalPRice ?></span>
			<span><strong>Total Quantity sold</strong>: <?= $totalQty ?></span>
			<span><strong>Total Quantity Affected</strong>: <?= $totalStockAffectedSold ?></span>
			<span><strong>Total buying cost</strong>: GHC <?= $totalSalesBuyingCost ?></span>
			<span><strong>Total Profit</strong>: GHC <?= $totalPRice - $totalSalesBuyingCost ?></span>
		</div>
	</div>

	<form  style='display: none' id='reportForm' method='get' action='reportGeneration.php'>
		<input type="text" id="cashierO" name="cashier" >
		<input type="date" id='startDateO' name="startDate">
		<input type="date" id='endDateO' name="endDate">
		<input type='submit' value='submit'>
	</form>

	<!-- <button id='reportButton'>Generate report</button> -->
	
	<!-- <a id='aa' href='reportGeneration.php?dat=<?php echo date("Y-m-d") ?>&period=daily'>Generate report</a>  -->
    
</section>	
	<?php include('footer.php');?>
	<script src="../js/jqD.js"></script>
	<script type="text/javascript">
		$(document).ready(function(){

		var table = $('#table').dataTable({
			"lengthMenu": [[50,100,200, -1], [50,100,200, "All"]]

		})
		

	})
		$('#export').click(function(){
			$('#cashierA').val($('#cashier').val())
			$('#paymentModeA').val($('#paymentMode').val())
			$('#startDateA').val($('#startDate').val())
			$('#endDateA').val($('#endDate').val())
			if($('#refund').is( ":checked" )) $('#refundA').prop('checked',true)
			else $('#refundA').prop('checked',false)

			$('#exportForm').submit()
			
		})

		$('#reportButton').click(function(){
			// console.log($('#cashier').val())
			$('#cashierO').val($('#cashier').val())
			$('#startDateO').val($('#startDate').val())
			$('#endDateO').val($('#endDate').val())

			$('#reportForm').submit()
			
		})
        


	</script>
</body>
</html>