<?php
session_start();
	if(!isset($_SESSION['username'])){
		header('location:login.php');
		exit;
	}

	include('../postfolder/connexion.php');

?>
<!DOCTYPE html>
<html>
<head>
	<link rel="stylesheet" href="../css/staffStyle.css?v=<?php time() ?>">
	<link rel="stylesheet" href="../css/font-awesome/css/font-awesome.min.css">	
	<link id="bs-css" href="../css/jqD.css" rel="stylesheet">
	<title></title>
<style>
	#table{
		width: 90%;
		margin:auto;
		margin-top:20px;
		border-collapse: collapse;
	}
	th{
		border:1px solid #aaa;
	}
	td{
		border:1px solid #aaa;
	}
	.dataTables_wrapper .dataTables_length, .dataTables_wrapper .dataTables_filter, .dataTables_wrapper .dataTables_info, .dataTables_wrapper .dataTables_processing, .dataTables_wrapper .dataTables_paginate{
		margin:20px;
	}
	img{
		width:200px;
		height:200px;
	}
	form input, form div textarea{
		width:70%;
		padding:7px;
		margin-bottom: 10px;
	}
	form label{
		font-weight: bold;
		display:block;
	}
	#form input[type=submit] {
	    width: unset;
	    padding: 10px 50px;
	    font-weight: bold;
	    background-color: black;
	    cursor: pointer;
	    color: white;
	    display:block;
	}
	.critical{
		color:red;
	}
	#aa{
		text-decoration: none;
		border: 1px solid black;
		padding: 8px 10px;
		color: black;
		margin-top: 20px;
		display: inline-block;
	}
	.aaa{
		text-decoration: none;
		border: 1px solid black;
		padding: 8px 10px;
		color: black;
		margin-top: 20px;
		display: inline-block;
	}
	#aaaActive{
		border: 1px solid #7baa2f;
		color: #7baa2f;
		padding: 8px 10px;
	}
	#item_name{
        left:300px;
        padding:5px;
        border-radius: 30px;
        margin-bottom: 20px;
    }
	table{
		width:80%;
	}
	td,th{
		text-align: center;
		padding:10px;
	}

	#maxImportFormDiv, #maxUpdateFormDiv{
		display: none;
	}
	#maxImportErrorDiv, #maxUpdateErrorDiv{
		background-color: #ea9191;
		padding: 2px;
		width: 100%;
		margin-bottom: 20px;
		display: none;
	}
	#maxImportFormDiv, #maxUpdateFormDiv{
		background-color: white;
		padding: 20px;
		border: 1px solid black;
		width: 60%;
	}
</style>
</head>
<body>
	<?php include('header.php'); ?>
<section>
	
	<a class='aaa' href='stock.php'>View stock list</a>
	<a class="aaa" href='store.php'>Edit stock list</a>
	<a class='aaa' href='bulkitems.php'>Edit bulk items</a>
	<a id="aaaActive" href='#'>Stock adj. history</a>

	<!-- <div style="margin-top: 10px;">
		<a id='storeReportLink' href='storeReport.php?sortVal=item_id ASC&category=&name='><button class='generateReport'> Generate report</button></a>
		<a  href='postfolder/stockExport.php'><button id='export'> Export</button></a>
	</div> -->
	<div>
		<button class='addSomething' id='maxImportButton'> Load stocks</button>
	</div>

	<div id='maxImportFormDiv'>
		
		<h3>Max import</h3>

		<div id='maxImportErrorDiv'>
			<ul id='maxImportErrorDivUl'>
			</ul>
		</div>

		<form>
			<input id='maxImportHidden' type="hidden" name='maxStockLoad'>

			<input type="file" name='file' required>
			
			<input id='checkFileBut' type="submit" value="Load stocks">
			<br><span>You can download a sample <a href='../sample/max_stock_load.xlsx' download='max_stock_load.xlsx'>here</a></span>
		</form>
	</div>

	<div>
		<table id='table'>
			<thead>
				<tr>
					<th>Adj. id</th>
					<th>Item id</th>
					<th>Item name</th>
					<th>Old Qty</th>
					<th>New Qty</th>
					<th>Stock Impact</th>
					<th>Channel</th>
					<th>Time</th>

					
				</tr>
			</thead>
			<tbody>
		<?php 
			$channels = [
				'supdate' => 'Single update',
				'stockloading' => 'Stock loading',
				'mimport' => 'Max import',
				'mupdate' => 'Max update'
			];

			$req = $bdd->query('SELECT sqa_id, sqa_item_id,sqa_squantity,sqa_equantity,sqa_quantity,sqa_time, item_name, sqa_channel FROM stockquantityadjust 
						LEFT JOIN item ON sqa_item_id = item_id
						ORDER BY sqa_time DESC ');
			while($reqq = $req->fetch()){	
				?>				
						<tr >
							<td><?php echo $reqq["sqa_id"];?></td>
							<td><strong><?php echo $reqq["sqa_item_id"];?></strong></td>
							<td><strong><?php echo $reqq["item_name"];?></strong> </td>
							<td><?php echo $reqq["sqa_squantity"];?></td>
							<td><?php echo $reqq["sqa_equantity"];?></td>
							<td><?php echo $reqq["sqa_quantity"];?></td>
							<td><?= ($reqq["sqa_channel"]) ? $channels[$reqq["sqa_channel"]] : '';?></td>
							<td><?php echo $reqq["sqa_time"];?></td>
							
						</tr>						
				<?php
			}
		?>
			</tbody>
		</table>
	</div>

</section>
<?php include('footer.php'); ?>
<script src="../js/jqD.js"></script>
<script type="text/javascript">
	$(document).ready(function(){

		var table = $('#table').dataTable({
			"lengthMenu": [[50,100,200, -1], [50,100,200, "All"]],
			"order": [[ 0, "desc" ]],
		})

	})

	$('#maxImportButton').click(function(){
		$('#form, #maxUpdateFormDiv').hide()
		$('#maxImportFormDiv').slideToggle(200)
	})

    $('#maxImportFormDiv form').submit(function(e){
		e.preventDefault()
		var formData = new FormData($(this)[0]);
		$('#maxImportErrorDiv').hide()
		
		$.ajax({
	       url:'postfolder/itemOperations.php',
	       type: 'POST',
	       data: formData,
	       async: true,
	       cache: false,
	       contentType: false,
	       enctype: 'multipart/form-data',
	       processData: false,
	       dataType:'text',
	        success: function(donnee,statut){

	        	if(donnee.trim() == 'ok'){
	        		notify('success','File imported.', function(){
	        			location.reload()
	        		})
	        	}
	        	else{

	        		$('#maxImportErrorDivUl').html(donnee)
	        		$('#maxImportErrorDiv').slideToggle(200)
	        		
	        	}
	        },
	        
		})	
	})
</script>
</body>
</html>