<?php
session_start();
	if(!isset($_SESSION['username'])){
		header('location:login.php');
		exit;
	}

	include('../postfolder/connexion.php');
	
	if(isset($_GET['itemD'])){
		$reqUI = $bdd->prepare('UPDATE item SET item_disabled="disabled" WHERE item_id = ?');
		$reqUI->execute(array(htmlspecialchars($_GET['itemD'])));
		header('location:store.php');
	}
	if(isset($_GET['itemA'])){
		$reqUI = $bdd->prepare('UPDATE item SET item_disabled="" WHERE item_id = ?');
		$reqUI->execute(array(htmlspecialchars($_GET['itemA'])));
		header('location:store.php');
	}
	$categories = [];
	$req = $bdd->query('SELECT * FROM itemcategory ORDER BY icId DESC');
	while($reqq = $req->fetch()){
		$categories[$reqq['icId']] = $reqq['iCName'];
	} 



?>
<!DOCTYPE html>
<html>
<head>
	<link rel="stylesheet" href="../css/staffStyle.css?v=<?php time() ?>">
	<link rel="stylesheet" href="../css/font-awesome/css/font-awesome.min.css">
	<link id="bs-css" href="../css/jqD.css" rel="stylesheet">
	<title></title>
<style>
	#table{
		width: 98% !important;
		margin:auto;
		margin-top:20px;
		border-collapse: collapse;
	}
	th{
		border:1px solid #aaa;
	}
	td{
		border:1px solid #aaa;
	}
	.dataTables_wrapper .dataTables_length, .dataTables_wrapper .dataTables_filter, .dataTables_wrapper .dataTables_info, .dataTables_wrapper .dataTables_processing, .dataTables_wrapper .dataTables_paginate{
		margin:20px;
	}
	img{
		width:200px;
		height:200px;
	}
	#form{
		display: none;
		background-color: white;
		padding: 20px;
		width: 60%;
		border: 1px solid grey;
	}
	form input, div textarea{
		width:70%;
		padding:7px;
		margin-bottom: 10px;
	}
	#form form label{
		font-weight: bold;
		display:block;
	}
	
	
	td{
		padding: 10px;
	}
	td input{
		padding: 3px;
	}
	.toBeHidden{
		display: none;
	}
	.aaa{
		text-decoration: none;
		border: 1px solid black;
		padding: 8px 10px;
		color: black;
		margin-top: 20px;
		display: inline-block;
	}
	#aaaActive{
		border: 1px solid #7baa2f;
		color: #7baa2f;
		padding: 8px 10px;
	}
	#maxImportFormDiv, #maxUpdateFormDiv{
		display: none;
	}
	#maxImportErrorDiv, #maxUpdateErrorDiv{
		background-color: #ea9191;
		padding: 2px;
		width: 100%;
		margin-bottom: 20px;
		display: none;
	}
	#maxImportFormDiv, #maxUpdateFormDiv{
		background-color: white;
		padding: 20px;
		border: 1px solid black;
		width: 60%;
	}

	.tableForm select{
		width: 100%;
	}
	.tableForm input[type=submit]{

	}

	.checkboxDiv{
		display: flex;
	}
	.checkboxDiv input{
		width: unset;
	}
</style>
</head>
<body>
	<?php include('header.php'); ?>
<section>
	<div style="margin-bottom:10px">
		<a class="aaa" href='stock.php'>View stock list</a>
		<a id='aaaActive' href='#'>Edit stock list</a>
		<a class='aaa' href='bulkitems.php'>Edit bulk items</a>
		<a class='aaa' href='sqa.php'>Stock adj. history</a>
	</div>

	<button class='addSomething' id='addButton'> Add product</button>
	<button class='addSomething' id='maxImportButton'> Max import</button>
	<button class='addSomething' id='maxUpdateButton'> Max Update</button>
	<div id='form'>

		<form >
			<input type='hidden' name='add'>
			
			<div>
				<label>Item name</label>
				<input type='text' name='item_name' id='itemName' required>
			</div>
			<div>
				<label>Item quantity</label>
				<input type='number' name='item_quantity'  required>
			</div>

			<div>
				<label>Item buying price</label>
				<input type='number' name='item_buy_price' step='0.1' required>
			</div>

			<div>
				<label>Item selling price</label>
				<input type='number' name='item_price' step='0.1' required>
			</div>
			<div>
				<label>Item Catgory</label>
				<select name='item_category' required>
					<option value=''>Choose the category</option>
					<?php
						$req = $bdd->query('SELECT * FROM itemcategory ORDER BY icId DESC');
						while($reqq = $req->fetch()){ ?>
							
							<option value="<?= $reqq['icId'] ?>"><?= $reqq['iCName'] ?></option>

					<?php } ?>
				</select>
			</div>

			<div>
				<label>Item Barcode</label>
				<input type='text' name='item_barcode' >
			</div>

			<div class='checkboxDiv' >
				<input type="checkbox" name='item_stockable' id='item_stockable'> <label for='item_stockable'>Stockable item</label>
				
			</div>
			
			<input type='submit' value='submit'>
		</form>
	</div>
	<div id='maxImportFormDiv'>
		
		<h3>Max import</h3>

		<div id='maxImportErrorDiv'>
			<ul id='maxImportErrorDivUl'>
			</ul>
		</div>

		<form>
			<input id='maxImportHidden' type="hidden" name='maxImportCheck'>

			<input type="file" name='file' required>
			
			<input id='checkFileBut' type="submit" value="Check file">
			<br><span>You can download a sample <a style='text-decoration: underline; color:#009688' href='../sample/max_import_sample.xlsx' download='max_import_sample.xlsx'>here</a></span>
		</form>
	</div>

	<div id='maxUpdateFormDiv'>
		<h3>Max Update</h3>
		<div id='maxUpdateErrorDiv'>
			<ul id='maxUpdateErrorDivUl'>
			</ul>
		</div>
		<form>
			<input id='maxUpdateHidden' type="hidden" name='maxUpdateCheck'>

			<input type="file" name='file' required>
			
			<input id='checkUpdateFileBut' type="submit" value="Check file">
			<br><span>You can download a sample <a style='text-decoration: underline; color:#009688' href='../sample/max_update_sample.xlsx' download='max_update_sample.xlsx'>here</a></span>
		</form>
	</div>

	<h2>Product List</h2>
	<div>
		<table id='table'>
			<thead>
			<tr>
				<th>Item id</th>
				<th>Category</th>
				<th class='toBeHidden'>Item name</th>
				<th>Item name</th>
				<th>Item quantity</th>
				<th>Buying price</th>
				<th>Selling price</th>
				<th>Stockable?</th>
				<th>Item Barcode</th>
				<th>Actions</th>
			</tr>
			</thead>
			<tbody id='productlisting'>
		<?php 
			$req = $bdd->query('SELECT * FROM item where isbv = 0 ORDER BY item_id DESC');
			while($reqq = $req->fetch()){

					$reqC = $bdd->prepare('SELECT * FROM itemcategory where icID = ?');
					$reqC->execute(array($reqq["item_icId"]));
					$reqqC = $reqC->fetch();
				?>
					
					
						
						<tr class='tableForm' id="<?= $reqq["item_id"];?>">
							<td><strong><?php echo $reqq["item_id"];?></strong></td>
							<td class='item_categoryID'>
								<select name='item_category' required>
									<option value=''>Choose the category</option>
									<?php
										foreach($categories as $key => $value){ 
											$selected = '';
											if($reqq["item_icId"] == $key) $selected = 'selected';
											?>
											
											<option value="<?= $key ?>" <?= $selected; ?>><?= $key ?></option>

									<?php } ?>
								</select>
									
							</td>
							<td class='toBeHidden nameTobeHidden'><?php echo $reqq["item_name"];?></td> 
							<td class='item_nameTd'><input type='text' name='item_name' id='item_name' value='<?php echo $reqq["item_name"];?>'  <?php if($reqq["item_disabled"] == 'disabled'){ echo 'disabled'; }?> ></td>
							<td class='item_quantityTd'><input type='number' name='item_quantity' value='<?php echo $reqq["item_quantity"];?>'  <?php if($reqq["item_disabled"] == 'disabled'){ echo 'disabled'; }?> ></td>
							
							<td class='item_buy_priceTd'><input type='number' step='0.1' name='item_buy_price' value='<?php echo $reqq["item_buy_price"];?>' <?php if($reqq["item_disabled"] == 'disabled'){ echo 'disabled'; }?>></td>

							<td class='item_priceTd'><input type='number' step='0.1' name='item_price' value='<?php echo $reqq["item_price"];?>' <?php if($reqq["item_disabled"] == 'disabled'){ echo 'disabled'; }?>></td>

							<td class='stockableTd'><input type='checkbox' name='item_stockable' <?= ($reqq["item_isstockable"]) ? 'checked':'' ?> <?php if($reqq["item_disabled"] == 'disabled'){ echo 'disabled'; }?>></td>


							<td class='item_barcodeTd'><input type='text' name='item_barcode' value='<?php echo $reqq["item_barcode"];?>' <?php if($reqq["item_disabled"] == 'disabled'){ echo 'disabled'; }?>></td>

							<td>
								<button class='actionButton'  <?= $reqq["item_disabled"] == 'disabled' ? 'disabled' : '' ?>>
									update
								</button>

								<!-- <input class='actionButton' type='submit' value='update' <?php if($reqq["item_disabled"] == 'disabled'){ echo 'disabled'; }?>> -->
							
							<?php if($reqq["item_disabled"] == 'disabled'){ ?>		
								<a href="store.php?itemA=<?php echo $reqq['item_id'];?>">Activate</a>
							<?php }else{ ?>
								<a href="store.php?itemD=<?php echo $reqq['item_id'];?>">Disable</a>
							<?php } ?>

							</td>
						</tr>
						
						
					
				<?php
			}
		?>
			</tbody>
		</table>
	</div>

</section>
<?php include('footer.php'); ?>
<script src="../js/jqD.js"></script>
<script>


	var table = $('#table').dataTable({
		"lengthMenu": [[50,100,200, -1], [50,100,200, "All"]]
	})
		

	$('#addButton').click(function(){
		$('#maxImportFormDiv, #maxUpdateFormDiv').hide()
		$('#form').slideToggle();
	})
	$('#maxImportButton').click(function(){
		$('#form, #maxUpdateFormDiv').hide()
		$('#maxImportFormDiv').slideToggle(200)
	})
	$('#maxUpdateButton').click(function(){
		$('#maxImportFormDiv, #form').hide()
		$('#maxUpdateFormDiv').slideToggle(200)
	})

	$('#form form').submit(function(e){
		e.preventDefault()
		
		var data = $(this).serialize();

	    $.ajax({
           url:'postfolder/itemOperations.php',
           type:'post',
           data:data,
           dataType:'text',
           success: function(donnee,statut){
           	console.log(donnee)
           		if(donnee.trim() == 'ok'){
           			$('#form form')[0].reset()
           			// $('#form').slideToggle();
	           		notify('success','Item added successfull. Please refresh to view changes ');		
				}
           },
           error:function(){
           
           }
	    })
	})

	$("#productlisting").on("click", ".actionButton", function (e){

		
		affectedTr = $(this).parent('td').parent('tr')
		id = affectedTr.attr('id')
		name = affectedTr.children('.item_nameTd').children().val()
		category = affectedTr.children('.item_categoryID').children().val()
		qty = affectedTr.children('.item_quantityTd').children().val()
		buyprice = affectedTr.children('.item_buy_priceTd').children().val()
		price = affectedTr.children('.item_priceTd').children().val()
		barcode = affectedTr.children('.item_barcodeTd').children().val()
		isstockable = affectedTr.children('.stockableTd').children().is(":checked")
		isstockablee = (isstockable) ? 1 : 0
		var data = {
			itemUpdate:'ok',
			item_id:id,
			name:name,
			category:category,
			qty:qty,
			buyprice:buyprice,
			price:price,
			barcode:barcode,
			isstockable:isstockablee
		}

		

	    $.ajax({
           url:'postfolder/itemOperations.php',
           type:'post',
           data:data,
           dataType:'text',
           success: function(donnee,statut){
           		
           		if(donnee.trim() == 'ok'){

           			affectedTr.children('.nameTobeHidden').text(name)
           			notify('success','Item updated');

				}
           },
           error:function(){
           
           }
	    })
	})

	$('#maxImportFormDiv form').submit(function(e){
		e.preventDefault()
		var formData = new FormData($(this)[0]);
		$('#maxImportErrorDiv').hide()
		
		$.ajax({
	       url:'postfolder/itemOperations.php',
	       type: 'POST',
	       data: formData,
	       async: true,
	       cache: false,
	       contentType: false,
	       enctype: 'multipart/form-data',
	       processData: false,
	       dataType:'text',
	        success: function(donnee,statut){

	        	if(donnee.trim() == 'pass'){
	        		$('#maxImportHidden').attr('name','maxImportUpload')
	        		$('#checkFileBut').replaceWith("<input type='submit' value='Upload'>")
	        		notify('success','File OK. You can now import.', function(){
	        			
	        		})
	        		
	        	}
	        	else if(donnee.trim() == 'ok'){
	        		notify('success','File imported.', function(){
	        			location.reload()
	        		})
	        	}
	        	else{

	        		$('#maxImportErrorDivUl').html(donnee)
	        		$('#maxImportErrorDiv').slideToggle(200)
	        		
	        	}
	        },
	        
		})	
	})

	$('#maxUpdateFormDiv form').submit(function(e){
		e.preventDefault()
		var formData = new FormData($(this)[0]);
		
		$.ajax({
	       url:'postfolder/itemOperations.php',
	       type: 'POST',
	       data: formData,
	       async: true,
	       cache: false,
	       contentType: false,
	       enctype: 'multipart/form-data',
	       processData: false,
	       dataType:'text',
	        success: function(donnee,statut){


	        	console.log(donnee)
	        	
	        	if(donnee.trim() == 'pass'){
	        		$('#maxUpdateHidden').attr('name','maxUpdateUpload')
	        		$('#checkUpdateFileBut').replaceWith("<input type='submit' value='Upload'>")
	        		notify('success','File OK. You can now import.', function(){
	        			
	        		})
	        		
	        	}
	        	else if(donnee.trim() == 'ok'){
	        		notify('success','File imported.', function(){
	        			location.reload()
	        		})
	        	}
	        	else{
	        		$('#maxUpdateErrorDivUl').html(donnee)
	        		$('#maxUpdateErrorDiv').slideToggle(200)
	        	}
	        },
	        
		})	
	})


		
	
</script>
</body>
</html>