<?php
session_start();
	if(!isset($_SESSION['username'])){
		header('location:login.php');
		exit;
	}
	include('../postfolder/connexion.php');
	
?>
<!DOCTYPE html>
<html>
<head>
	<meta charset='utf-8'>
	<link rel='stylesheet' href='../css/staffStyle.css'>
	<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1"/>
	<meta name="HandheldFriendly" content="true" />
	<link rel="stylesheet" href="../css/font-awesome/css/font-awesome.min.css">
	<link id="bs-css" href="../css/jqD.css" rel="stylesheet">
	<title></title>

<style type="text/css">
	#table{
		width: 90%;
		margin:auto;
		margin-top:20px;
		border-collapse: collapse;
	}
	th{
		border:1px solid #aaa;
	}
	td{
		border:1px solid #aaa;
	}
	.dataTables_wrapper .dataTables_length, .dataTables_wrapper .dataTables_filter, .dataTables_wrapper .dataTables_info, .dataTables_wrapper .dataTables_processing, .dataTables_wrapper .dataTables_paginate{
		margin:20px;
	}
	table{
		width:800px;
		border-collapse: collapse;
	}
	td,th{
		text-align: center;
		padding:10px;
		border-bottom: 1px solid black;
	}
	section form input, section div textarea{
		width:70%;
		/*border:1px solid #02ccba;*/
		padding:7px;
		margin-bottom: 10px;
	}
	section form label{
		/*color:#02ccba;*/
	}
	
	#s_passwordDiv{
		display:none;
	}
	#addButton{
		padding: 8px 17px;

	}
	#form{
		display: none;
		background-color: white;
		padding: 20px;
		width: 60%;
		border: 1px solid grey;
	}
</style>
</head>
<body>
	<?php include('header.php'); ?>
<section>

<div id='content'>

	<button class='addSomething' id='addButton'> Add a worker</button>
	<form id='form' method='post' action='postfolder/addworkerpost.php'>

		<h1 style='margin-top:50px'>Add a worker</h1>

		<?php
			if(isset($_GET['error'])){
				?>
				<p class="error">
					<?php echo $_GET['error'];?>
				</p>
				<?php
			}
			else if(isset($_GET['success'])){
				?>
				<p class="success">
					<?php echo $_GET['success'];?>
				</p>
				<?php
			}else{
				?>
				<p class="message">
				Fill the form
				</p>
				<?php
			}
			?>

		<div>
			<label for='ID'> ID</label>
			<input type='text' name='ID' required id='ID'>
		</div>
		<div>
			<label for='s_name'> Name</label>
			<input type='text' name='s_name' id='s_name' required >
		</div>
		<div>
			<label for='s_address'> Address</label>
			<input type='text' name='s_address' required id='s_address'>
		</div>
		<div>
			<label for='s_gender'> Gender</label>
			<select name='s_gender' id='s_gender'>
				<option>Choose</option>
				<option>M</option>
				<option>F</option>
			</select>
		</div>
		
		<div>
			<label for='s_phone'>Phone number </label>
			<input type='tel' name='s_phone' required id='s_phone' placeholder="Ex: +233567098756" maxlength="13">
		</div>
		<div>
			<label for='s_dob'> Date Of Birth</label>
			<input type='date' name='s_dob' required id='s_dob'>
		</div>
		<div>
			<label for='s_category'> Position</label>
			<select  name='s_category' id='s_category'>
				<option>Choose</option>
				<option>Cashier</option>
				<option>Delivery</option>
				<option>Security</option>
				<option>SalesAssistant</option>
			</select>
		</div>
		<div>
			<label for='salaryAmount'> Salary</label>
			<input type='number' name='salaryAmount' required id='salaryAmount'>
		</div>

		<div id='s_passwordDiv'>
			<label for='s_password'> Password</label>
			<input type='password' name='s_password' id='s_password'>
		</div>
		<input type="submit" value="Add">
	</form>
		
	<h1>Worker's list <a href="postfolder/workerExport.php"><button id='export'> Export</button></a></h1>
		<div>
			<table id='table'>
				<thead>
				<tr>
					<th>Name</th>
					<th>Username</th>
					<th>Gender</th>
					<th>Departement</th>
					<th>Actions</th>
				</tr>
				</thead>
				<tbody>
			<?php
				$reqIncome = $bdd->query('SELECT * FROM workers ORDER BY ID');
				while($reqqIncome = $reqIncome->fetch()){
				?>
				<tr>
					<td><?php echo $reqqIncome['s_name'];?></td>
					<td><?php echo $reqqIncome['ID'];?></td>
					<td><?php echo $reqqIncome['s_gender'];?></td>
					<td><?php echo $reqqIncome['s_category'];?></td>
					
					<td><a href="workerDetails.php?ID=<?php echo $reqqIncome['ID']; ?>"> <i class="actionButtonI fa fa-plus"></i></a></td>
					
				</tr>
				<?php
				}
			?>
			</tbody>
			</table>
		</div>
		

	
</div>
</section>

<?php include('footer.php');?>
<script src="../js/jqD.js"></script>
<script type="text/javascript">
	$(document).ready(function(){

		var table = $('#table').dataTable({
			// "order": [[ 3, "desc" ], [ 4, "desc" ],],
			// "columnDefs" : [{targets:[6,3], type:"date"}],
			"lengthMenu": [[50,100,200, -1], [50,100,200, "All"]]

		})
		

	})
	$('#addButton').click(function(){
		$('#form').slideToggle();
	})

	$(s_category).change(function(){
		if($(this).val() == 'Cashier') $(s_passwordDiv).show()
		else $(s_passwordDiv).hide()
	})
	$(s_name).change(function(){
		if(/[0-9]+/.test($(this).val())){
				alert('The name can not contain a number')
		}
	})
	$(s_phone).change(function(){
		if(/[a-zA-Z]+/.test($(this).val())){			
			alert('the phone number can not contain a letter')
		}
	})

	
</script>
</body>
</html>