<?php
	session_start();
	
	// if(isset($_SESSION['username'])){
	// 	header('location:index.php');
	// 	exit;
	// }
?>
<!DOCTYPE html>
<html>
<head>
	<meta charset='utf-8'>
	<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1"/>
	<meta name="HandheldFriendly" content="true" />
	<title></title>
<style type="text/css">
	*{
		box-sizing: border-box;
	}
	html{
		height: 100%;
	}
	body{
		height: 90%;
	}

	section{
		display: flex;
		justify-content: center;
		align-items: center;
		height: 100%;
	}
	#content{
		padding:20px 22px;
		display:flex;
		justify-content: center;
		align-items: center;
		background-color: #8080804a;
		width: max-content;
	}
	#loginlogo{
		height: 150px;
	}
	section form{
		width:400px;
		padding:30px 3%;
		box-sizing: border-box;
		position: relative;
		color:black;
	}
	label{
		display:block;
		font-weight: bold;
		margin-bottom: 5px;
		color: black;
	}
	section input{
		width:100%;
		padding: 10px;
		font-weight: bold;
		border:0px;
	}
	#hideshow{
		display:block;
		text-align: right;
		margin: 10px;
		font-size: 18px;
	}
	#hideshow label{
		display:unset;
	}
	#hideshow input{
		width: unset;
	}
	section input[type=submit]{
		border: 2px solid black;
	    background-color: black;
	    color: white;
	    width: 50%;
	    margin: 20px auto;
	    cursor: pointer;
	    transition: .5s;
	    display: block;
	}
	section input[type=submit]:hover{
		/*border:1px solid #02b3e4;*/
	}
	#accountP{
		text-align: center; 
		position: absolute;
		width: 100%;
		bottom: 10px;
		font-size: 17px;
	}
	#accountP a {
		color:white;
		text-decoration: none;
		border-bottom: 5px solid #02b3e4;
		transition:.3s;
		display:inline-block;
	}
	#accountP a:hover{
		transform: scale(1.15);
	}
	.error{
		background-color:#C83939;
	}
	.error, .success{
		background-color:#C83939;
		padding:2% 4px;
		border-radius:5px;
		text-align: center;
		color:white;
	}
	.message{
		font-weight: bold;
	}
@media all and (max-width:500px){
	#content{
		padding:5%;
	}
	section form{
		width:unset;
	}
}
</style>
</head>
<body>
	
<section>
	<div id='content'>
	<form method='post' action='postfolder/loginpost.php'>
		<?php
	if(isset($_GET['error']) || isset($_COOKIE['lock'])){
		?>
		<p class="error">
			<?php if(isset($_COOKIE['error'])) echo $_GET['error'];?>
			<span><?php if(isset($_COOKIE['error'])) echo '<br>You have '. (3 - (int)$_COOKIE['error']) .' attemps(s) left' ?></span>
			<?php

			if(isset($_COOKIE['lock'])){ ?>
				<br><span>Your attempts are exceded.</span>
			<br><br><span style='display: block'> You must wait for <span id='timeDisplay'><?php echo $_COOKIE['lock'] - time(); ?> </span>s</span>
			<span style='display:none' id='timesample'><?php echo $_COOKIE['lock'] - time(); ?></span>
			<?php
			}else if(isset($_COOKIE['inactive'])){ ?>
				<span>Your account is not active, contact the admin.</span>
			<?php }
			?>
			
			</p>

				<?php
		}
		else{
		?>
			<p class="message">
				Enter your credentials. You have only <strong><em>03 attemps</em></strong>.
			</p>
		<?php
		}
				
			?>
		<label>Username </label><input type="text" name="username" placeholder=""  <?php if(isset($_COOKIE['lock'])) echo 'disabled' ?> required><br/><br/>
		<label>Password </label><input type="password" name="password" placeholder="" id='password' <?php if(isset($_COOKIE['lock'])) echo 'disabled' ?> required> 
		<span id='hideshow'> <input type="checkbox" id="showPassword"> <label for='showPassword'>Show</label> </span>
		<input type="submit" value='Log in'>
		<!-- <p id='accountP'>Dœsn't have account yet? <a href='register.php'>Create one</a></p> -->
	</form>

	
</div>
</section>
	<script type="text/javascript" src='js/jq.js'></script>
	<script type="text/javascript" src='js/cookie.js'></script>
	<script type="text/javascript">
		var showPassword = $('#showPassword');
		var password = $('#password');
		var timeDisplay = $('#timeDisplay');
		var timesample = $('#timesample');

		showPassword.click(function(){
			if($(this).prop("checked") == true) {
				password.attr('type','text')
				$('label[for=showPassword]').text('Hide')
			}else {
				password.attr('type','password')
				$('label[for=showPassword]').text('Show')
			}
		})

		setInterval(function(){
			var nbSec = parseInt(timesample.text())-1
			if(nbSec < 0) location.href='index.php';
			else {
				timesample.text(nbSec);
				timeDisplay.text(Math.floor(nbSec/60)+'m:'+(nbSec%60))
				
			}
		},1000)
	</script>
</body>
</html>