<?php
session_start();
if(!isset($_SESSION['ID'])){
	header('location:../index.php');
	exit;
}
	include('../postfolder/connexion.php');
?>
<!DOCTYPE html>
<html>
<head>
	<link rel="stylesheet" href="../css/style.css?v=<?php time() ?>">
	<link rel="stylesheet" href="../css/font-awesome/css/font-awesome.min.css">
	<link id="bs-css" href="../css/jqD.css" rel="stylesheet">
	<title>Petty cash</title>
<style>
	#table{
		
		margin:auto;
		margin-top:20px;
		border-collapse: collapse;
	}
	th{
		border:1px solid #aaa;
	}
	td{
		border:1px solid #aaa;
	}
	.dataTables_wrapper .dataTables_length, .dataTables_wrapper .dataTables_filter, .dataTables_wrapper .dataTables_info, .dataTables_wrapper .dataTables_processing, .dataTables_wrapper .dataTables_paginate{
		margin:20px;
	}


	#complain{
		display: none;
	}
	#sAMSuh{
		background-color: #02ccba;
	    background: linear-gradient(#02CCC6,#02ccba);
	    font-weight: bold;
	    color: white;
	    font-size: 80%;
	    padding: 5px 15px 5px 15px;
	    border-radius: 5px;
	    display: inline-block;
	    cursor: pointer;
	}
	/* messages */
		#messageList div{
				display:flex;
				background-color:#e3e6de;
				border-bottom:3px solid #eeeeee;
				padding:7px;
				cursor:pointer;
			}	

			#messageList div:hover{
				color:green;
				text-decoration:underline;
			}
			.nonlu{
				background-color:white !important;
				font-weight:bold;
			}
			.tdmsgheur{
				border-left:5px solid white;
				padding-left:10px;
				width:130px;
			}
			.nonlu .tdmsgheur{
				border-color:grey;
			}
			.tdmsgaut{
				color:#118dac;
				width:14%;
				border-right:3px solid white;
				overflow: hidden;
				    white-space: nowrap;
				    text-overflow: ellipsis;
			}
			.tdmsgsujet{
				font-weight:bold;
				    margin-left: 15px;
				    flex: 1;
				    position: relative;
				    overflow: hidden;
				    white-space: nowrap;
				    text-overflow: ellipsis;
				    
			}
			.tdmsgsujet a{
				text-decoration: none;
				color:black;
			}

	#switchDiv{
		position: absolute;
		display:flex;
		right:5%;
		align-items: center;
	}
	#switchDiv span{
		font-weight: bold;
		display:inline-block;
		margin-left: 3px;
	}
	#secEncloser{
		display:flex;
		margin: auto;
		justify-content: center;

	}	
	#messageListEncloser{
		position: relative;
		min-width: 30%;
		flex:1;
		margin-top: 40px;
		max-height: 500px;
		overflow: scroll;
		
	}
	#messageShowDiv{
		width: 70%;
		min-height: 300px;
		display: none;
		background-color: white;
		margin-top: 40px;
		padding:10px;
		position: relative;
	}
	#messageShowDiv h3{
		position: relative;
		border-bottom: 1px solid #80808066;
		padding-bottom: 10px;
	}
	#messageShowDiv h3 em{
		position: absolute;
		right:10px;
	}
	.messageShowDivClose{
		position: absolute;
		top:-10px;
		font-size: 26px;
		right:-10px;
		cursor: pointer;
		color:#02ccba;
	}	


	.fHeaderActive{
		border-bottom: 2px solid black;
		transition: .3s;
	}
	.fHeader{
		
	}
	.fContent > div{
		display:none;
	}
	.fContent > div:first-of-type{
		display:unset;
	}

	section form input, section div textarea{
		width:70%;
		/*border:1px solid #02ccba;*/
		padding:7px;
		margin-bottom: 10px;
	}
	section form label{
		/*color:#02ccba;*/
	}
	input[type=submit] {
	    width: unset;
	    padding: 10px 50px;
	    font-weight: bold;
	    background: linear-gradient(88deg, #323267, #323267);
	    cursor: pointer;
	    color: white;
	    display:block;
	}
</style>
</head>
<body>
<?php include('header.php'); ?>
<section>
<div style='width:90%;margin:auto;margin-top:30px'>
	<!-- <h1>Record a complain/request</h1> -->
	<button id='addMessage' style="padding: 7px 15px;">Record a petty cash</button>
	<?php

		if(isset($_GET['error'])){
			?>
			<p style='width:500px; border-width: 1px; padding:5px' class="error">
				<?php echo $_GET['error'];?>
			</p>
			<?php
		}
		else if(isset($_GET['success'])){
			?>
			<p style='width:500px; border-width: 1px; padding:5px' class="success">
				<?php echo $_GET['success'];?>
			</p>
			<?php
		}
	?>
	<div id='complain'>
		<form method='post' action='postfolder/complainpost.php'>
			<input type="hidden" name="recordPettyCash">
			<div>
				<label for='c_customerName'> Staff name</label>
				<select name='cashier' id='cashier'>
					<option value=''>All staffs</option>
					<?php
						$reqWorker = $bdd->query('SELECT * FROM workers where s_category != "Admin" ORDER BY ID ');

						while($reqWorkers = $reqWorker->fetch()){ 
							$selected = '';

							if($reqWorkers['ID'] == $cashier) $selected = 'selected';
							?>
							<option value="<?php echo $reqWorkers['ID'];?>" <?= $selected ?>><?php echo $reqWorkers['s_name'];?></option>
						<?php }
					?>
				</select>
			</div>
			<div>
				<label for='amount'>Amount </label>
				<input type='number' name='amount' required id='amount'  >
			</div>
			
			<div>
				<label for='reason'> Reason</label>
				<textarea type='text' name='reason' rows='6' required id='reason'></textarea>
			</div>
			<input type='submit' value="Record">
		</form>
	</div>	

	<h1>Petty cash</h1>

	<table id='table'>
		<thead>
			<tr>
				<th>N•</th>
				<th>Staff ID</th>
				<th>Staff Name</th>
				<th>Amount</th>
				<th>Reason</th>
				<th>Date & time</th>
			</tr>
		</thead>
		<tbody>
		<?php 
			$i = 1;


			$req = $bdd->prepare('SELECT pc_staff_id, pc_amount, pc_reason, pc_date, s_name FROM pettycash LEFT JOIN  workers ON ID = pc_staff_id  WHERE pc_recording_staffs = ?ORDER BY pc_date DESC LIMIT 500');
			$req->execute(array($_SESSION['ID']));
			
			while ($reqq = $req->fetch()) {
			?>
				<tr>

					<td><?php echo $i;?></td>
					<td><?php echo $reqq['pc_staff_id'];?></td>
					<td><?php echo $reqq['s_name'];?></td>
					<td><?php echo $reqq['pc_amount'];?></td>
					<td><?php echo $reqq['pc_reason'];?></td>
					<td><?php echo aDate($reqq['pc_date']);?></td>
					
				</tr>
				<?php
				$i++;
			
			}
		?>
			</div>
		
		
		
		</div>
		</div>
		
	</div>
</div>
</section>
<?php include('footer.php'); ?>
<script src="../js/jqD.js"></script>
<script type="text/javascript">

	$(document).ready(function(){
		var table = $('#table').dataTable({
			"lengthMenu": [[50,100,200, -1], [50,100,200, "All"]]
		})
	})

	$('#addMessage').click(function(){
		$('#complain').toggle(200)
	})

	 $(oNotRead).change(function(){
        	if($(this).is(':checked')) {
        		
        		$.ajax({
                url:'postfolder/complainPost.php',
                type:'post',
                data:'messageNotRead=ok',
                dataType:'json',
                success: function(donne,statut){
                	$(messageList).empty();
                    donne.forEach(function(dt){

                    	var nonlu = '';
                    	if(!dt['seen']) nonlu = 'nonlu';
                    	$('<div>')
                    	.addClass('messageDiv '+nonlu)                    	
                    	.append("<span class='tdmsgsujet'><a href='complainDetails.php?c_id="+dt['c_id']+"'>"+dt['c_title']+"</a></span>")
                    	.append($('<span>').text(afDate(dt['c_date'])).attr('class','tdmsgheur'))
                    	.appendTo($(messageList))
                    })
                }

        		})	
        	}else{
        		$.ajax({
                url:'postfolder/complainPost.php',
                type:'post',
                data:'messageAll=ok',
                dataType:'json',
                success: function(donne,statut){
                	$(messageList).empty();
                    donne.forEach(function(dt){
                    	var nonlu = '';
                    	if(!dt['seen']) nonlu = 'nonlu';
                    	$('<div>')
                    	.addClass('messageDiv '+nonlu)                    	
                    	.append("<span class='tdmsgsujet'><a href='complainDetails.php?c_id="+dt['c_id']+"'>"+dt['c_title']+"</a></span>")
                    	.append($('<span>').text(afDate(dt['c_date'])).attr('class','tdmsgheur'))
                    	.appendTo($(messageList))
                    })
                }

        		})
        	}
        })


	// $(phoneNumber).change(function(){
	// 	if(/[a-zA-Z]+/.test($(this).val())){			
	// 		alert('the phone number can not contain a letter')
	// 	}
	// })

	// $(c_customerName).change(function(){
	// 	if(/[0-9]+/.test($(this).val())){
	// 			alert('The name can not contain a number')
	// 	}
	// })
</script>
	

</body>
</html>