<?php
session_start();
if(!isset($_SESSION['ID'])){
	header('location:login.php');
	exit;
}
include('../../postfolder/connexion.php');

require '../../vendor/vendor/autoload.php';

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xls;

	$rq = $bdd->prepare('SELECT s_name FROM workers WHERE ID = ?');
    $rq->execute(array($_SESSION['ID']));
    $rqq = $rq->fetch();

    $paymentMode = [
		'cash' => 'Cash',
		'mobile' => 'Mobile Money',
		'credit' => 'Credit Card'
	];

    $req = $bdd->prepare('SELECT * FROM sales WHERE sa_s_ID = ? AND sa_date = CURDATE() ORDER BY sa_id DESC');
    $req->execute(array($_SESSION['ID']));

    $data = [];
   
    
	
    while($reqq = $req->fetch()){
		$line = [
			'orderNumber' => $reqq['sa_id'],
			'Quantity' => $reqq['sa_itemQuantity'],
			'SumTotal' => $reqq['sa_totalPrice'],
			'paymentMode' => $reqq['payment_method'],
			'SalesDate' => $reqq['sa_date'],
			'Salestime' => $reqq['sa_time'],
		];
		array_push($data, $line);
	}

$spreadsheet = new Spreadsheet();
$sheet = $spreadsheet->getActiveSheet(0);

$sheet->setCellValue('A1', 'ORDER NUMBER');
$sheet->setCellValue('B1', 'TOTAL QUANTITY');
$sheet->setCellValue('C1', 'TOTAL AMOUNT');
$sheet->setCellValue('D1', 'PAYMENT MODE');
$sheet->setCellValue('E1', 'DATE');
$sheet->setCellValue('F1', 'TIME');





$rowNo = 2;

	foreach ($data as $row) {

		$sheet->setCellValue('A'.$rowNo, $row['orderNumber']);
		$sheet->setCellValue('B'.$rowNo, $row['Quantity']);
		$sheet->setCellValue('C'.$rowNo, $row['SumTotal']);
		$sheet->setCellValue('D'.$rowNo, $paymentMode[$row['paymentMode']]);
		$sheet->setCellValue('E'.$rowNo, $row['SalesDate']);
		$sheet->setCellValue('F'.$rowNo, $row['Salestime']);

		$rowNo++;
	}
$fileName = $rqq['s_name'].'-sales-for-'.date("d-m-Y").'.xls';
header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header('Content-Disposition: attachment; filename="'. urlencode($fileName).'"');
$writer = new Xls($spreadsheet);
$writer->save('php://output');