<?php
session_start();
if(!isset($_SESSION['ID'])){
	header('location:../index.php');
	exit;
}
	
include('../postfolder/connexion.php');
?>
<!DOCTYPE html>
<html>
<head>
	<link rel="stylesheet" href="../css/style.css?v=<?php time() ?>">
    <link rel="stylesheet" href="../css/font-awesome/css/font-awesome.min.css">
	<title></title>
<style>
	#iSearchResult{
		display:block;
	}
    #iSearchResultEnclos::before {
        content: "\f002";
        font: normal normal normal 14px/1 FontAwesome;
        position: absolute;
        left: 10px;
        top: 2px;
        font-size: 18px;
        color: #02ccba;
    }
    #itemInput {
        border: 1px solid #323267;
        padding: 10px 5px 10px 30px;
        border-radius: 30px;
        width: 230px;
        margin-bottom: 10px;
    }
    #checkBut{
        font-size: 90%;
        margin-top:43px;
        padding: 3px 10px;
    }
    #cart{
        background-color: white;
    }
    #cart tr{
        border: 1px solid black;
    }
    table{
        width:600px;
        margin-bottom: 50px;
    }
    th{
        text-align: center;
        padding: 20px 10px 20px 5px;
    }
    td{
        padding: 20px 10px 20px 0px;
        text-align: center;
        
    }
    #total{
        font-weight: bold;
    }
    table i{
        margin:20px 0px;
    }
    table i:hover{
        transform:scale(1.2);
    }
    .itemListDiv{
        display: flex;
        width: 800px;
        margin:10px;
    }
    .itemListDiv span{
        width: calc(100%/5);
    }
    .hd{
        font-weight: bold;
    }
    .hdDiv{
        display:none;
    }
    #receiveAmount{
        display:block;
        position: absolute;
        /*left:00px;*/
        padding:5px;
        border-radius: 30px;
        /*margin: 10px 0px;*/
        width: 200px;
    }
    #discountPercentage{
        display:block;
        position: relative;
        padding:5px;
        border-radius: 30px;
        margin-bottom: 20px;
        width: 200px;
    }
    #paymentDiv{
        margin: 15px 0px;
    }
    #paymentDiv label{
        display: unset;
    }
    #deliveryFee{
        display: block;
        position: relative;
        
        padding: 5px;
        border-radius: 20px;
        margin-bottom: 30px;
        width: 200px;
    }
    #discountAndDelivery{
        width: 600px;
        display: flex;
        justify-content: space-between;
    }
</style>
</head>
<body>
	<?php include('header.php'); ?>
<section>

	<h2>Record a new sale</h2>
	<span style="position: relative;" id='iSearchResultEnclos'>
    	<input type='text' name='itemInput' id='itemInput' placeholder="Search for a item">
        <div class='hdDiv'>
            <div class='hd itemListDiv'>
                <span >Item name</span> 
                <span >Unit price</span> 
                <span>Available quantity</span>
                <span></span>
            </div>

        <span id='iSearchResult'>
            
        </span>
        </div>
    </span>
    <table id='cart'>
    	<tr>
    		<th>Item name</th>
    		<th>Unit price</th>
    		<th>Item quantity</th>
    		<th>Total price</th>
    	</tr>
    	<tr id='total'>
    		<th colspan="2">Sum Total</th>
    		<td id='totalQuantity'>0</td>
    		<td id='ttPrice'>0</td>
    	</tr>
    </table>

    <div id='discountAndDelivery'>
        <div>
            <label>Delivery fee ( GHC )</label>
            <input type="number" name='deliveryFee' id='deliveryFee' step='0.1' placeholder="Enter the delivery fee">
        </div>
        <div>
            <label>Fixed discount amount ( GHC )</label>
            <input type="number" name='discountPercentage' id='discountPercentage' placeholder="Enter discount amount">
        </div>
       
    </div>

    <div id='paymentDiv'>
        <input type="radio" name='paymentMode' value='cash' id='cash' checked> <label for='cash'>Cash</label>
        <input type="radio" name='paymentMode' id='mobile' value='mobile'> <label for='mobile'>Mobile Money</label> 
        <input type="radio" name='paymentMode' id='credit' value='credit'> <label for='credit'>Credit Card</label>
    </div>


    <input type='number' id='receiveAmount' placeholder="Amount received">

    <button id='checkBut'><i class='fa fa-check' ></i>Check out</button>
</section>	
<?php include('footer.php');?>
<script src='../js/onscan.min.js'></script>
<script type="text/javascript">
    paymentMode = 'cash'

    $('input[type=radio][name=paymentMode]').change(function() {
        paymentMode = this.value
        if (paymentMode != 'cash') {
            $('#receiveAmount').attr('placeholder','Reference ID')
        }else{
             $('#receiveAmount').attr('placeholder','Amount Received')
        }

        // console.log(paymentMode)
    });

    /*$(document).on('keydown', function(e) {
        if((e.ctrlKey || e.metaKey) && (e.key == "p" || e.charCode == 16 || e.charCode == 112 || e.keyCode == 80) ){
            alert("Please use the Print PDF button below for a better rendering on the document");
            e.cancelBubble = true;
            e.preventDefault();

            e.stopImmediatePropagation();
        }  
    });*/


	var chosenItemTab = {}
    actualPrice = 0;

	$('#itemInput').on('keyup',function(e){
        $(iSearchResult).empty()
        $('.hdDiv').hide()
        if($(itemInput).val().length > 0){
            $.ajax({
                url:'postfolder/salesOperations.php',
                type:'post',
                data:'itemInput=ok&value='+$(itemInput).val(),
                dataType:'json',
                success: function(donne,statut){
                    
                    
                    $('.hdDiv').show()

                    if(donne.length < 1){
                    	$(iSearchResult).text("No item for that name")
                    }

                    donne.forEach(function(dt){
                        // console.log(dt)
                        var nextThing = $("<button class='add'>Add</button>");
                        variationButon =  '';
                    	qty = dt['item_quantity']

                       

                        if(dt['item_isstockable'] > 0 && qty == 0) {
                            nextThing = $("<span>Out of stock</span>");
                            nextThing.css('color','red')
                        } 

                        if(dt['item_isstockable'] > 0 && dt['bv_item_id'] > 0 && dt['existing_qty'] == 0) {
                            nextThing = $("<span>Out of stock</span>");
                            nextThing.css('color','red')
                        } 


                        if(dt['bv_qty'] > 0) qty = dt['existing_qty'];
                        if(chosenItemTab[dt['item_id']]){
                            qty  = qty - chosenItemTab[dt['item_id']][0]
                        }

                        let qtyToShow = qty,
                        maxQty = 'max='+qty;

                        if(dt['item_isstockable']  == 0) {
                            qtyToShow = 'Available';
                            maxQty = '';
                        }


                        $('<div>')
                        .attr('id',dt['item_id'])
                        .attr('data-bv_item_id', dt['bv_item_id'])
                        .attr('data-item_buy_price', dt['item_buy_price'])
                        .attr('data-bv_qty', dt['bv_qty'])
                        .attr('data-item_isstockable', dt['item_isstockable'])
                        .addClass('itemListDiv')
                        .append($('<span>').text(dt['item_name']).addClass('name'))
                        .append(' ')
                        .append($('<span>').text(dt['item_price']).addClass('price'))
                        .append(' ')
                        .append($('<span>').text(qtyToShow))
                        .append($("<input style='padding:5px; width:65px' type='number' name='qut'  value='1' min='0' "+maxQty+">"))
                        
                        .append(nextThing)
                        .appendTo($(iSearchResult));
						
                    })                       
                }
            })
        }
    })

    $(document).on('click','.itemListDiv .add',function(e){
    	
    	var divParent = $(this).parent();

        qtyElem = divParent.children('input')
        qty = parseFloat(qtyElem.val())
        qtyMax = parseFloat(qtyElem.attr('max'))
        if(qty > qtyMax){
            alert('You cannot add more than the available stock')
            return false;
        }
        
        var quantity = parseFloat(divParent.children('input').val())

    	var id = divParent.attr('id')
        var name = divParent.children('.name').text();        	
    	var price = parseFloat(divParent.children('.price').text());
    	var quantity = parseFloat(divParent.children('input').val())
        var bv_qty = parseFloat(divParent.attr('data-bv_qty'))
        var bv_item_id = parseFloat(divParent.attr('data-bv_item_id'))
        var item_buy_price = parseFloat(divParent.attr('data-item_buy_price'))
        var item_isstockable = parseFloat(divParent.attr('data-item_isstockable'))

    	
    	$(totalQuantity).text(parseFloat($(totalQuantity).text())+quantity)
        actualPrice = actualPrice+(quantity*price)
        sumPrice = actualPrice
        
        discountValue = parseFloat($('#discountPercentage').val())
        deliveryFee = parseFloat($('#deliveryFee').val())
        if(!Number.isNaN(discountValue)) sumPrice = actualPrice -  discountValue
        if(!Number.isNaN(deliveryFee)) sumPrice = actualPrice +  deliveryFee

    	$('#ttPrice').text(sumPrice)

        cQTY = parseFloat($('#a'+id+' .qt').text())

        if( cQTY > 0){
            newQTY = parseFloat($('#a'+id+' .qt').text())+quantity
            $('#a'+id+' .qt').text(newQTY)
            $('#a'+id+' .ttpr').text(parseFloat($('#a'+id+' .ttpr').text()) +(quantity*price))

            chosenItemTab[id] = [newQTY,price,bv_qty,bv_item_id, item_isstockable,item_buy_price]
        }else{
            $('<tr>')
            .attr('id','a'+id)
            .append($('<td>').text(name).addClass('name'))          
            .append($('<td>').text(price).addClass('pr'))
            .append($('<td>').text(quantity).addClass('qt'))
            .append($('<td>').text(quantity*price).addClass('ttpr'))
            .append("<i class='fa fa-trash'></i>")
            .insertBefore($('#total'))

            chosenItemTab[id] = [quantity,price,bv_qty,bv_item_id, item_isstockable,item_buy_price]
        }

        $('#itemInput').val('')
    	$(iSearchResult).empty()
        $('.hdDiv').hide()
         
        $('#itemInput').focus()  
    })

    $('#deliveryFee').keyup(function(){

        
        deliveryFee = parseFloat($(this).val())
        if(Number.isNaN(deliveryFee)) deliveryFee = 0

        plusDeliveryFee = actualPrice + deliveryFee

        discount = parseFloat($('#discountPercentage').val())
        if(Number.isNaN(discount)) discount = 0
        discountPrice = discount

        discountSum = plusDeliveryFee - discountPrice

        
        // plusDeliveryFee = discountSum + deliveryFee;
        // console.log(discountPrice)
        $('#ttPrice').text(discountSum)
    })

    $('#discountPercentage').keyup(function(){

        
        discount = parseFloat($(this).val())
        if(Number.isNaN(discount)) discount = 0
        discountPrice = discount

        discountSum = actualPrice - discountPrice

        deliveryFee = parseFloat($('#deliveryFee').val())
        if(Number.isNaN(deliveryFee)) deliveryFee = 0
        plusDeliveryFee = discountSum + deliveryFee;
        // console.log(discountPrice)
        $('#ttPrice').text(plusDeliveryFee)
    })
    
    $(document).on('click','table i',function(e){	
    	var divParent = $(this).parent();
    	var id = divParent.attr('id')        	
    	var totalPrice = parseFloat(divParent.children('.ttpr').text());
    	var quantity = parseFloat(divParent.children('.qt').text())
    	

    	divParent.remove()
    	$(totalQuantity).text(parseFloat($(totalQuantity).text())-quantity)
        actualPrice = actualPrice-totalPrice

        sumPrice = actualPrice
        discountValue = parseFloat($('#discountPercentage').val())
        deliveryFee = parseFloat($('#deliveryFee').val())
        if(!Number.isNaN(discountValue)) sumPrice = actualPrice - discountValue
        if(!Number.isNaN(deliveryFee)) sumPrice = actualPrice +  deliveryFee
        $('#ttPrice').text(sumPrice)

        
    	delete(chosenItemTab[id.substring(1,)]) 
   
    })
    
    $(checkBut).click(function(){
        ref = $(receiveAmount).val()
        ttPrice = parseFloat($('#ttPrice').text())
        
        if(Number.isNaN(parseFloat($('#receiveAmount').val()))){
            return false;
        }
        
        discount = parseFloat($('#discountPercentage').val())
        if(Number.isNaN(discount)) discount = 0
        pMode = paymentMode
        
        deliveryFee = parseFloat($('#deliveryFee').val())
        if(Number.isNaN(deliveryFee)) deliveryFee = 0

        if(paymentMode == 'cash' ){
            
            if(parseFloat(ref) < parseFloat(ttPrice)){
                alert('The amount received cannot be less than the total price')
                return false;
            }
        }

    
    	var data = {
    		sale: 'ok',
    		totalQuantity: $(totalQuantity).text(),
    		totalPrice: ttPrice,
    		chosenItem: chosenItemTab, 
            discount: discount,
            paymentMode: pMode,
            deliveryFee:deliveryFee,
            ref: ref
    	}

        
    	$.ajax({
                url:'postfolder/salesOperations.php',
                type:'post',
                data:data,
                dataType:'text',
                success: function(donne,statut){
                    console.log(donne)
                    location.href = 'receipt.php?sa_id='+donne
                    
                }

        })
    })

    // onScan.attachTo(document, {
    //     suffixKeyCodes: [13], // enter-key expected at the end of a scan
    //     reactToPaste: true,
    // })

    // document.addEventListener('scan', function(sScancode, iQuantity) {

    //     setTimeout(function(){
    //         $(iSearchResult).empty()
    //          $.ajax({
    //             url:'postfolder/salesOperations.php',
    //             type:'post',
    //             data:'itemInput=ok&value='+$(itemInput).val(),
    //             dataType:'json',
    //             success: function(donne,statut){
    //                 $('.hdDiv').show()

    //                 if(donne.length < 1){
    //                     $(iSearchResult).text("No item for that name")
    //                 }

    //                 donne.forEach(function(dt){
    //                 // if(!chosenItemTab[dt['item_id']]){

    //                     var nextThing = $("<button class='add'>Add</button>");
    //                     qty = dt['item_quantity']

    //                     if(chosenItemTab[dt['item_id']]){
    //                         qty  = qty - chosenItemTab[dt['item_id']][0]
    //                     }

    //                     if(qty == 0) {
    //                         nextThing = $("<span>Out of stock</span>");
    //                         nextThing.css('color','red')
    //                     } 
    //                     $('<div>')
    //                     .attr('id',dt['item_id'])
    //                     .addClass('itemListDiv')
    //                     .append($('<span>').text(dt['item_name']).addClass('name'))
    //                     .append(' ')
    //                     .append($('<span>').text(dt['item_price']).addClass('price'))
    //                     .append(' ')
    //                     .append($('<span>').text(qty))
    //                     .append($("<input style='padding:5px' type='number' name='qut' value='1' min='0' max='"+qty+"'>"))
    //                     .append(nextThing)
    //                     .appendTo($(iSearchResult));
    //                     // }
    //                 })                       
    //             }
    //         })
    //         // console.log('')
    //     },100)
         
    // });

</script>
</body>
</html>